<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed.');
}

/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * Typography Helpers
 */

/**
 * Convert newlines to HTML line breaks except within PRE tags
 *
 * @access	public
 * @param	string
 * @return	string
 */
if (! function_exists('nl2br_except_pre')) {
    function nl2br_except_pre($str)
    {
        ee()->load->library('typography');

        return ee()->typography->nl2br_except_pre($str);
    }
}

/**
 * Auto Typography Wrapper Function
 *
 *
 * @access	public
 * @param	string
 * @param	bool	whether to allow javascript event handlers
 * @param	bool	whether to reduce multiple instances of double newlines to two
 * @return	string
 */
if (! function_exists('auto_typography')) {
    function auto_typography($str, $strip_js_event_handlers = true, $reduce_linebreaks = false)
    {
        ee()->load->library('typography');

        return ee()->typography->auto_typography($str, $strip_js_event_handlers, $reduce_linebreaks);
    }
}

/**
 * HTML Entities Decode
 *
 * This function is a replacement for html_entity_decode()
 *
 * @access	public
 * @param	string
 * @return	string
 */
if (! function_exists('entity_decode')) {
    function entity_decode($str, $charset = 'UTF-8')
    {
        return ee('Security/XSS')->entity_decode($str, $charset);
    }
}

// EOF
