<?php
/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * Channel Parser Component (Switch)
 */
class EE_Channel_switch_parser implements EE_Channel_parser_component
{
    /**
     * Quick check if they're using switch
     *
     * @param array		A list of "disabled" features
     * @return Boolean	Is disabled?
     */
    public function disabled(array $disabled, EE_Channel_preparser $pre)
    {
        return ! $pre->has_tag('switch');
    }

    /**
     * No preprocessing required.
     *
     * @param String	The tagdata to be parsed
     * @param Object	The preparser object.
     * @return void
     */
    public function pre_process($tagdata, EE_Channel_preparser $pre)
    {
        return null;
    }

    /**
     * Replace the switch tag based on what step of the loop we're in.
     *
     * @param String	The tagdata to be parsed
     * @param Object	The channel parser object
     * @param Mixed		The results from the preparse method
     *
     * @return String	The processed tagdata
     */
    public function replace($tagdata, EE_Channel_data_parser $obj, $pre)
    {
        return ee()->TMPL->parse_switch($tagdata, $obj->count(), $obj->prefix());
    }
}
