<?php

/**
 * JCOGS Image Filter
 * ==================
 * A Contrast filter.
 * 
 * @return object $image
 * 
 * CHANGELOG
 * 
 * 12/12/2022: 1.3      First release
 * 
 * =====================================================
 *
 * @category   ExpressionEngine Add-on
 * @package    JCOGS Image
 * @author     JCOGS Design <contact@jcogs.net>
 * @copyright  Copyright (c) 2021 - 2023 JCOGS Design
 * @license    https://jcogs.net/add-ons/jcogs_img/license.html
 * @version    1.3.21.1
 * @link       https://JCOGS.net/
 * @since      File available since Release 1.3
 */

 namespace JCOGSDesign\Jcogs_img\Filters\Gd;

use Imagine\Filter\FilterInterface;
use Imagine\Image\ImageInterface;

/**
 * A Contrast filter.
 */
class Contrast implements FilterInterface
{
    /**
     * @var int
     */
    private $level;

    /**
     * Constructs Contrast filter.
     *
     * @param int $level
     */
    public function __construct(int $level)
    {
        $this->level = $level;
    }

    /**
     * {@inheritdoc}
     *
     * @see \Imagine\Filter\FilterInterface::apply()
     */
    public function apply(ImageInterface $image)
    {
        // Get the GDImage object
        $img = imagecreatefromstring($image->__toString());

        // Filter the image
        if(imagefilter($img, IMG_FILTER_CONTRAST, $this->level)) {
            // Worked - so bale!
            $image = ee('jcogs_img:ImageUtilities')->convert_GDImage_object_to_image($img);
            unset($img);
        } else {
            // Failed - so note and return
            ee('jcogs_img:Utilities')->debug_message(lang('jcogs_img_contrast_failed'));
        }
        return $image;
    }
}
