<?php 
/**
 * Redirect Pro
 *
 * @package     ExpressionEngine
 * @subpackage  Addons
 * @category    Module
 * @author      Imam Husayn
 * @link        
 */

include_once 'addon.setup.php';

Class Redirect_pro_ext{

	public $name       	= IHRP_NAME;
    public $version        = IHRP_VERSION;
    public $description    = IHRP_DESCRIPTION;
    public $settings_exist = 'n';
    public $docs_url       = 'http://google.com'; //
	public $settings        = array();

	function __construct($settings='')
    {
        $this->settings = $settings;
    }

	public function activate_extension()
    {	
    	//first, we delete if there is the already extension
        ee()->db->where('class', 'Redirect_pro_ext');
        ee()->db->delete('extensions');

        ee()->functions->clear_caching('db');

        //add hook sessions_start
        $data = array(
            'class'    => __CLASS__,
            'method'   => 'sessions_start',
            'hook'     => 'sessions_start',
            'settings' => '',
            'priority' => 10,
            'version'  => IHRP_VERSION,
            'enabled'  => 'y',
        );

        ee()->db->insert('extensions', $data);

        return true;

    }

    public function disable_extension()
    {

    	ee()->db->where('class', __CLASS__);
        ee()->db->delete('extensions');
    	return true;

    }

    public function update_extension($current = false)
    {

    	if ($current == '' OR $current == $this->version)
	    {
	        return FALSE;
	    }

	    ee()->db->where('class', __CLASS__);
	    ee()->db->update(
	                'extensions',
	                array('version' => $this->version)
	    );

    }

    public function sessions_start()
    {

    	//ignore CP
    	if (REQ == 'CP') {
            return false;
        }

        //get current site URL;
        $get_url = ee()->db->escape_str(urldecode(trim(ee()->uri->uri_string)));
        $get_slash_url = ee()->db->escape_str(urldecode(trim('/'.ee()->uri->uri_string)));

        $sql = "SELECT *
                FROM exp_redirects
                WHERE (start_date = 0 OR start_date IS NULL OR start_date <= NOW())
                AND (end_date = 0 OR end_date IS NULL OR end_date >= NOW())
                AND ( redirect_from = '" . $get_url . "' OR redirect_from = '" . $get_slash_url . "' ) 
                AND site_id = " . ee()->config->item('site_id');
        $redirect_data = ee()->db->query($sql)->row_array();

        if(!empty($redirect_data)){

        	$do_redirect = false;

	        //get current site URL
	        $site_url   = (ee()->config->item('site_url')) ? rtrim(ee()->config->item('site_url'),'/') . '/' : '';
            $site_index = (ee()->config->item('site_index')) ? rtrim(ee()->config->item('site_index'),'/') .'/' : '';
            $make_site_url = $site_url . $site_index;
	        $redirect_to = ltrim(trim($redirect_data['redirect_to']), '/');

	        //increase the count of that records

	        //don't get issue of the same url
	        if($get_url == $redirect_to){
	        }else{
		        //check redirect to is external or internal
		        if( strpos($redirect_to, 'http://') !== FALSE OR  strpos($redirect_to, 'https://') !== FALSE){

		        	//dont get issue issue of the same url
		        	if($redirect_to == $make_site_url.$get_url){
		        	}
		        	else{
		        		$do_redirect = true;
		        	}
		        }else{
		        	$do_redirect = true;
		        	$redirect_to = $make_site_url.$redirect_to;
		        }
	        }

	        if($do_redirect == true){
	        	//increse the redirect count
	        	$get_redirect = ee('Model')->get('redirect_pro:Redirect', $redirect_data['redirect_id'])->first();
	        	$get_redirect->count = $get_redirect->count + 1;
	        	$get_redirect->save();
		        
		        //then do redict
		        header('Location: '.$redirect_to, true); 
	        	exit; 
	        }

        }

    }
}