<?php

namespace Reinos\Iconfont\Core\Installation;

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

/**
 * Include the config file
 */
require_once(PATH_THIRD.'reinos_iconfont/config.php');

class Installation_custom extends Installation_base
{

    public function __construct()
    {
        parent::__construct();
    }

    // ----------------------------------------------------------------

    public function install()
    {

        //Default action route
        $this->register_action('act_route', 1);

        //install the extension
        $this->register_hook('sessions_start');
        $this->register_hook('cp_js_end');

        //create the Login backup tables
        $this->create_tables();

        // create some custom presets
        foreach (ee(REINOS_ICONFONT_SERVICE_NAME.':Provider')->providers as $key => $provider) {
            ee('Model')->make(REINOS_ICONFONT_SERVICE_NAME.':Preset')->set([
                'site_id' => ee()->config->item('site_id'),
                'name' => $provider['name'],
                'provider' => $key,
                'json_preset' => ee(REINOS_ICONFONT_SERVICE_NAME.':Provider')->getJson($key)
            ])->save();
        }
    }

    public function uninstall()
    {
        //remove databases
        foreach($this->mysql_table_data as $table => $data)
        {
            ee()->dbforge->drop_table(REINOS_ICONFONT_MAP.'_'.$table);
        }
    }

    // ----------------------------------------------------------------

    /**
     * Create a tab
     *
     * @return 	boolean 	TRUE
     */
    public function tabs()
    {
        $tabs['tab_name'] = array(
            'field_name_one'=> array(
                'visible'   => 'true',
                'collapse'  => 'false',
                'htmlbuttons'   => 'true',
                'width'     => '100%'
            ),
            'field_name_two'=> array(
                'visible'   => 'true',
                'collapse'  => 'false',
                'htmlbuttons'   => 'true',
                'width'     => '100%'
            ),
        );

        return $tabs;
    }

	
} // END CLASS
