<?php
/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

use Reinos\Iconfont\Service\Curl;
use Reinos\Iconfont\Service\Installer;
use Reinos\Iconfont\Service\License;
use Reinos\Iconfont\Service\Log;
use Reinos\Iconfont\Service\Helper;
use Reinos\Iconfont\Service\Settings;
use Reinos\Iconfont\Service\SettingsHelper;
use Reinos\Iconfont\Service\Version;
use Reinos\Iconfont\Service\Preset;
use Reinos\Iconfont\Service\Provider;

require_once(PATH_THIRD.'reinos_iconfont/config.php');

return [
	'author'      => REINOS_ICONFONT_AUTHOR,
	'author_url'  => REINOS_ICONFONT_AUTHOR_URL,
	'name'        => REINOS_ICONFONT_TITLE,
	'description' => REINOS_ICONFONT_DESCRIPTION,
	'version'     => REINOS_ICONFONT_VERSION,
	'docs_url'  => REINOS_ICONFONT_DOCS,
	'settings_exist' => TRUE,
	'namespace'   => 'Reinos\Iconfont',
	'services.singletons' => [
//        'Paging' => function($ee) {
//            return new Paging();
//        },
		'Installer' => function($ee) {
			return new Installer;
		},
		'Settings' => function($ee) {
			return new Settings;
		},
	],
	'services' => [
		'Version' => function($ee) {
			return new Version;
		},
		'Curl' => function($ee) {
			return new Curl;
		},
		'SettingsHelper' => function($ee) {
			return new SettingsHelper;
		},
		'License' => function($ee) {
			return new License;
		},
		'Helper' => function($ee) {
			return new Helper;
		},
		'Log' => function($ee) {
			return new Log;
		},
        'Preset' => function($ee) {
            return new Preset;
        },
        'Provider' => function($ee) {
            return new Provider;
        },
	],
	'models' => [
		'Log' => 'Model\Log',
		'Settings' => 'Model\Settings',
		'Preset' => 'Model\Preset',
	],
];
