<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

use EllisLab\ExpressionEngine\Library\CP\Table;

/**
 * Include the config file
 */
require_once PATH_THIRD.'reinos_iconfont/config.php';

class Reinos_iconfont_mcp {

	public $return_data;
	public $settings;

	private $show_per_page = 25;
	private $_base_url;
	private $error_msg;

	/**
	 * Constructor
	 */
	public function __construct()
	{
		$this->base_url = ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP);

		//add cp css
		ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->act_url.'&method=cp_css');

		//if there is no valid license, redirect to the license page
		if(REINOS_ICONFONT_LICENSE_ENABLED && !ee(REINOS_ICONFONT_SERVICE_NAME.':License')->hasValidLicense() && (ee()->uri->segment(5) != 'license' && ee()->uri->segment(5) != 'logs'))
		{
			ee()->functions->redirect(ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/license/'));
		}

		//require the default settings
		require PATH_THIRD.REINOS_ICONFONT_MAP.'/settings.php';
	}

	// ----------------------------------------------------------------

	/**
	 * Index Function
	 *
	 * @return 	void
	 */
	public function index()
	{
		///show error if needed
		if ($this->error_msg != '')
		{
			return $this->error_msg;
		}

		//load the view
		return $this->settings();
	}

	// ----------------------------------------------------------------

	/**
	 * Settings Function
	 *
	 * @return 	void
	 */
	public function settings()
	{
		//is there some data tot save?
		if(isset($_POST) && !empty($_POST))
		{
			//validate the form
			$formValidationResult = ee('Validation')
				->make(array())
				->validate($_POST);

			//assign to vars
			$vars['errors'] = $formValidationResult;

			//save only when it is valid
			if ($formValidationResult->isValid())
			{
				ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->save_post_settings();
			}
		}

		//set the settings form
		$vars['sections'] = array(
			array(),
			REINOS_ICONFONT_MAP.'_log_settings' => array(
				array(
					'title' => REINOS_ICONFONT_MAP.'_log',
					'desc' => 'What should we log?',
					'fields' => array(
						'log_severity' => array(
							'type' => 'radio',
							'value' => ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('log_severity'),
							'choices' => array(
								'errors' => 'only errors',
								'all' => 'Everything',
								'none' => 'Nothing',
							),
							'required' => TRUE
						)
					)
				),
			),
            'Debug' => array(
                array(
                    'title' => REINOS_ICONFONT_MAP.'_debug_mode',
                    'desc' => 'Enter debug mode to load the unminified JS/CSS version.',
                    'fields' => array(
                        'debug_mode' => array(
                            'type' => 'yes_no',
                            'value' => ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('debug_mode'),
                            'required' => false,
                        )
                    )
                ),
            ),
		);

		// Final view variables we need to render the form
		$vars += array(
			'base_url' => ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP),
			'cp_page_title' => lang('general_settings'),
			'save_btn_text' => 'btn_save_settings',
			'save_btn_text_working' => 'btn_saving',
			'extra_alerts' => array(
				REINOS_ICONFONT_MAP.'_settings'
			)
		);

		return $this->output('form', $vars, 'settings');
	}

    // ----------------------------------------------------------------

    /**
     * Settings Function
     *
     * @return 	void
     */
    public function presets()
    {
        //delete action
        if(isset($_POST['delete']) && !empty($_POST['delete']))
        {
            //do your delete stuff here
            ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Preset')->filter('preset_id', ee()->input->post('delete'))->delete();

            //set a message
            ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_notice')
                ->asSuccess()
                ->withTitle(lang('success'))
                ->addToBody('Preset ID #'.ee()->input->post('delete')." deleted")
                ->defer();

            ee()->functions->redirect(ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/'.__FUNCTION__));
            exit;
        }

        //--------------------------
        //custom settings
        $title_page = 'Presets overview';
        $action_buttons = array(
            REINOS_ICONFONT_MAP.'_add_preset' => ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/preset_save')
        );
        $per_page = 25;
        $sort_col = ee()->input->get('sort_col') ?: 'column_preset_id';
        $sort_dir = ee()->input->get('sort_dir') ?: 'desc';
        //end custom settings
        //-------------------------

        // Specify other options
        $table = ee('CP/Table', array(
            'sort_col' => $sort_col,
            'sort_dir' => $sort_dir
        ));

        //set the columns
        $table->setColumns(
            array(
                'column_name',
                'column_provider',
                'manage' => array(
                    'type'  => Table::COL_TOOLBAR
                )
            )
        );

        //set a no result text
        $table->setNoResultsText('No presets available');

        //get all data
        $cur_page = ((int) ee()->input->get('page')) ?: 1;
        $offset = ($cur_page - 1) * $per_page; // Offset is 0 indexed

        $results = ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Preset')
            ->order(str_replace('column_', '', $table->config['sort_col']), $table->config['sort_dir'])
            ->limit($per_page)
            ->filter('site_id', ee()->config->item('site_id'))
            ->offset($offset);

        //format the data
        $data = array();
        $ids = array();
        foreach ($results->all() as $result)
        {
            //save IDS for the delete confirm dialog
            $ids[] = array(
                'id' => $result->preset_id,
                'msg' => 'ID:'
            );

            //set the data
            $data[] = array(
                $result->name,
                $result->provider,
                array('toolbar_items' => array(
                    'edit' => array(
                        'href' => ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/preset_save/'.$result->preset_id),
                        'title' => lang('edit')
                    ),
                    'remove' => array(
                        'href' => '',
                        'title' => lang('remove'),
                        'rel' => "modal-confirm-".$result->preset_id,
                        'class' => 'm-link'
                    )
                ))
            );
        }

        //set the data
        $table->setData($data);

        // Pass in a base URL to create sorting links
        $base_url = ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/presets');
        $vars['table'] = $table->viewData($base_url);
        $vars['base_url'] = $vars['table']['base_url'];
        $vars['action_url'] = $base_url;
        $vars['ids'] = $ids;

        //create the paging
        $vars['pagination'] = ee('CP/Pagination', $results->count())
            ->perPage($per_page)
            ->currentPage($cur_page)
            ->render($base_url);

        //Set the title
        $vars['title_page'] = $title_page;

        //set the buttons
        $vars['action_buttons'] = $action_buttons;

        return $this->output('overview', $vars, $title_page);
    }

    // ----------------------------------------------------------------

    /**
     * Settings Function
     *
     * @param int $id
     * @return    void
     */
    public function preset_save($id = 0)
    {
        $preset_query = ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Preset')->filter('preset_id', $id);

        //is there some data tot save?
        if(isset($_POST) && !empty($_POST))
        {
            if($_POST['provider'] == 'custom') {
                $_POST['json_preset'] = $_POST['json_preset_custom'];
            }

            //validate the form
            $formValidationResult = ee('Validation')
                ->make(array(
                    'name' => 'required',
                    'provider' => 'required',
                ))
                ->validate($_POST);

            //assign to vars
            $vars['errors'] = $formValidationResult;

            //save only when it is valid
            if ($formValidationResult->isValid())
            {
                $saved_data = [
                    'site_id' => ee()->config->item('site_id'),
                    'name' => ee()->input->post('name'),
                    'provider' => ee()->input->post('provider'),
                    'json_preset' => ee()->input->post('json_preset'),
                    'custom_css_url' => ee()->input->post('custom_css_url'),
                ];

                if($preset_query->count() == 0) {
                    ee('Model')->make(REINOS_ICONFONT_SERVICE_NAME.':Preset')->set($saved_data)->save();
                } else {
                    $preset_query->first()->set($saved_data)->save();
                }

                //set a message
                ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_notice')
                    ->asSuccess()
                    ->withTitle(lang('success'))
                    ->addToBody(lang('Preset saved'))
                    ->defer();

                //redirect
                ee()->functions->redirect(ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/presets'));
            }
        }

        ee()->cp->add_js_script(array(
            'file' => array('cp/form_group'),
        ));

        $preset_data = [
            'name' => '',
            'provider' => '',
            'json_preset' => '',
            'custom_css_url' => '',
        ];

        if($preset_query->count() > 0) {
            $preset = $preset_query->first();
            $preset_data['name'] = $preset->name;
            $preset_data['provider'] = $preset->provider;
            $preset_data['json_preset'] = $preset->json_preset;
            $preset_data['custom_css_url'] = $preset->custom_css_url;
        }

        //set the settings form
        $vars['sections'] = array(
            array(
                array(
                    'title' => REINOS_ICONFONT_MAP.'_preset_name',
                    'fields' => array(
                        'name' => array(
                            'type' => 'text',
                            'value' => $preset_data['name'],
                            'required' => TRUE
                        )
                    )
                ),
                array(
                    'title' => REINOS_ICONFONT_MAP.'_preset_provider',
                    'fields' => array(
                        'provider' => array(
                            'type' => 'radio',
                            'value' => $preset_data['provider'],
                            'choices' => array(
                                'font_awesome' => 'Font Awesome',
                                'material' => 'Material',
                                'custom' => 'Custom',
                            ),
                            'group_toggle' => array(
                                'font_awesome' => 'native_options',
                                'material' => 'native_options',
                                'custom' => 'custom_options',
                            ),
                            'required' => TRUE
                        )
                    )
                ),
                array(
                    'title' => REINOS_ICONFONT_MAP.'_json_preset',
                    'desc' => 'Enter your preset for this provider. If no preset is give, it will load the default set of <strong>all</strong> items. See the <a target="_blank" href="https://docs.reinos.nl/iconfont">documentation</a> for how to use.',
                    'group' => 'native_options',
                    'fields' => array(
                        'json_preset' => array(
                            'type' => 'textarea',
                            'value' => $preset_data['json_preset'],
                        ),
                        'add_default_preset' => array(
                            'type' => 'html',
                            'content' => '<button data-act-url="'.ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->act_url.'&method=fetch_json&provider=" style="font-size: 12px;padding:3px 5px; margin:0;" class="btn action iconfont_add_default_preset">Load default set</button>',
                        )
                    )
                ),
                array(
                    'title' => REINOS_ICONFONT_MAP.'_json_preset',
                    'desc' => 'Enter your custom preset.',
                    'group' => 'custom_options',
                    'wide' => true,
                    'fields' => array(
                        'json_preset_custom' => array(
                            'type' => 'textarea',
                            'value' => $preset_data['json_preset'],
                        ),
                    )
                ),
                array(
                    'title' => REINOS_ICONFONT_MAP.'_custom_css_url',
                    'desc' => 'Enter your the url of your stylesheet where the fonts can be found. (one url per line). See the <a target="_blank" href="https://docs.reinos.nl/iconfont">documentation</a> for how to use.',
                    'group' => 'custom_options',
                    'fields' => array(
                        'custom_css_url' => array(
                            'type' => 'textarea',
                            'value' => $preset_data['custom_css_url'],
                            'attrs' => 'rows="10"'
                        )
                    )
                ),
            ),
        );

        $buildVersion = ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('debug_mode') === 'y' ? 'development' : 'production';
        ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('js_custom_path', ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('theme_url') . 'dist/iconfont.' . $buildVersion . '.bundle.js');
        ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('theme_url') . 'dist/iconfont.bundle.css');

        ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('js_inline', '
            REINOS_ICONFONT_JSON_EDITOR("textarea[name=\"json_preset\"]");
            REINOS_ICONFONT_JSON_EDITOR("textarea[name=\"json_preset_custom\"]");
        ');

        // Final view variables we need to render the form
        $vars += array(
            'base_url' => ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/preset_save/'.$id),
            'cp_page_title' => lang('Add Preset'),
            'save_btn_text' => lang('Save preset'),
            'save_btn_text_working' => 'btn_saving',
        );

        return $this->output('form', $vars, 'settings');
    }

	// ----------------------------------------------------------------

	/**
	 * License Function
	 *
	 * @return array
	 */
   /* public function license()
    {
        //redirect to the login page of reinos
        if(isset($_GET['auth']) && ee()->input->get('auth') == 'yes')
        {
            $ret = str_replace('&auth=yes', '', reduce_double_slashes(ee()->config->item('site_url').$_SERVER['REQUEST_URI']));
            $data = json_encode(array(
                'return' => $ret,
                'license_key' => ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('license_key'),
                'module_name' => str_replace('reinos_', '', REINOS_ICONFONT_MAP)
            ));
            ee()->functions->redirect('https://addons.reinos.nl/auth?data='.base64_encode($data));
        }

        //login successfull from addons.reinos.nl
        if(isset($_GET['auth']) && (ee()->input->get('auth') == 'success' || ee()->input->get('auth') == 'failed'))
        {
            //save the member ID
            ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->save_setting('license_reinos_member_id', ee()->input->get('member_id'));
            ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->set_setting('license_reinos_member_id', ee()->input->get('member_id'));

            //check the license with the server
            $license_check = ee(REINOS_ICONFONT_SERVICE_NAME.':License')->checkLicense(ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('license_key'), ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('license_reinos_member_id'));

            //License check okay?
            if($license_check->success)
            {
                //set a message
                ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_settings')
                    ->addToBody(ee()->lang->line('preferences_updated'))
                    ->asSuccess()
                    ->withTitle(lang('success'))
                    ->addToBody($license_check->message)
                    ->now();
            }
        }

        //is there some data tot save?
        if(isset($_POST) && !empty($_POST))
        {
            //validate the form
            $formValidationResult = ee('Validation')
                ->make(array(
                    'license_key' => 'required'
                ))
                ->validate($_POST);

            //assign to vars
            $vars['errors'] = $formValidationResult;

            //save only when it is valid
            if ($formValidationResult->isValid())
            {
                //save the settings
                ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->save_post_settings('/license&auth=yes');
            }
        }

        //License not correct?
        if(!ee(REINOS_ICONFONT_SERVICE_NAME.':License')->hasValidLicense())
        {
            //set a message
            ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_license')
                ->asIssue()
                ->withTitle(lang('error'))
                ->addToBody('You have an incorrect license. Enter a valid license in order to activate the addon.')
                ->now();
        }

        //set the settings form
        $vars['sections'] = array(
            array(
                array(
                    'title' => REINOS_ICONFONT_MAP.'_license_key',
                    'desc' => 'Your license key',
                    'fields' => array(
                        'license_key' => array(
                            'type' => 'text',
                            'value' => ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('license_key'),
                            'required' => TRUE
                        )
                    )
                ),
                array(
                    'title' => '',
                    'fields' => array(
                        'info' => array(
                            'type' => 'html',
                            'content' => '
                                <div class="reinos-license_status">
                                    <div class="reinos-license-info" id="'.REINOS_ICONFONT_MAP.'_license_status">
                                        <span class="st-closed invalid_license" style="display: none;">Invalid license</span>
                                        <span class="st-closed unlicensed" style="display: none;">Unlicensed</span>
                                        <span class="st-info valid_license" style="display: none;">Valid license</span>
                                    </div>
                                   
                                    <h4>License info</h4>
                                    <ul>
                                        <li>Every valid license will work on every local development <i>(*.local, *.test, *.dev or *.localhost)</i>. </li>
                                        <li>
                                            In order to let your license work on your domain, <strong>you have to set the production url</strong> and/or test url. This can be done in you account on
                                            <a href="https://addons.reinos.nl/profile/licenses" target="_blank">addons.reinos.nl</a>.
                                        </li>
                                        <li>
                                            If you run a MSM site, you have to enter all your MSM sites in your account on <a href="https://addons.reinos.nl/profile/licenses" target="_blank">addons.reinos.nl</a>.
                                        </li>
                                        <li>
                                            Running with an invalid license, will <strong>cease the addon to work</strong>.
                                        </li>
                                        <li>If you bought a license in the EE store, it will transferred also to your account on <a href="https://addons.reinos.nl/profile/licenses" target="_blank">addons.reinos.nl</a></li>
                                        <li>By using this software, you agree to the <a href="https://addons.reinos.nl/commercial-license" target="_blank">Add-on License Agreement.</a></li>
                                    </ul>
                                </div>
                                '
                        )
                    )
                )
            )
        );

        // Final view variables we need to render the form
        $vars += array(
            'base_url' => ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/license'),
            'cp_page_title' => lang(REINOS_ICONFONT_MAP.'_license_settings'),
            'save_btn_text' => 'save and auth license',
            'save_btn_text_working' => 'btn_saving',
            'extra_alerts' => array(
                REINOS_ICONFONT_MAP.'_settings',
                REINOS_ICONFONT_MAP.'_license',
            )
        );

        return $this->output('form', $vars, 'settings');
    }
    */

	// ----------------------------------------------------------------

	/**
	 * Overview Function
	 *
	 * @return 	void
	 */
	public function logs()
	{
		//delete action
		if(isset($_POST['delete']) && !empty($_POST['delete']))
		{
			//do your delete stuff here
			ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Log')->filter('log_id', ee()->input->post('delete'))->delete();

			//set a message
			ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_notice')
				->asSuccess()
				->withTitle(lang('success'))
				->addToBody('Log ID #'.ee()->input->post('delete')." deleted")
				->defer();

			ee()->functions->redirect(ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/'.__FUNCTION__));
			exit;
		}

		//--------------------------
		//custom settings
		$title_page = 'Log overview';
		$action_buttons = array(
			REINOS_ICONFONT_MAP.'_delete_all_logs' => ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/delete_all_logs')
		);
		$per_page = 25;
		$sort_col = ee()->input->get('sort_col') ?: 'column_log_id';
		$sort_dir = ee()->input->get('sort_dir') ?: 'desc';
		//end custom settings
		//-------------------------

		// Specify other options
		$table = ee('CP/Table', array(
			'sort_col' => $sort_col,
			'sort_dir' => $sort_dir
		));

		//set the columns
		$table->setColumns(
			array(
				'column_log_id',
				'column_severity',
				'column_time',
				'column_message',
				'manage' => array(
					'type'  => Table::COL_TOOLBAR
				)
			)
		);

		//set a no result text
		$table->setNoResultsText('No logs available');

		//get all data
		$cur_page = ((int) ee()->input->get('page')) ?: 1;
		$offset = ($cur_page - 1) * $per_page; // Offset is 0 indexed

		$results = ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Log')
			->order(str_replace('column_', '', $table->config['sort_col']), $table->config['sort_dir'])
			->limit($per_page)
			->filter('site_id', ee()->config->item('site_id'))
			->offset($offset);

		//format the data
		$data = array();
		$ids = array();
		foreach ($results->all() as $result)
		{
			//save IDS for the delete confirm dialog
			$ids[] = array(
				'id' => $result->log_id,
				'msg' => 'ID:'
			);

			//set the data
			$data[] = array(
				$result->log_id,
				$result->severity,
				ee()->localize->human_time($result->time),
				$result->message,
				array('toolbar_items' => array(
					'remove' => array(
						'href' => '',
						'title' => lang('remove'),
						'rel' => "modal-confirm-".$result->log_id,
						'class' => 'm-link'
					)
				))
			);
		}

		//set the data
		$table->setData($data);

		// Pass in a base URL to create sorting links
		$base_url = ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/logs');
		$vars['table'] = $table->viewData($base_url);
		$vars['base_url'] = $vars['table']['base_url'];
		$vars['action_url'] = $base_url;
		$vars['ids'] = $ids;

		//create the paging
		$vars['pagination'] = ee('CP/Pagination', $results->count())
			->perPage($per_page)
			->currentPage($cur_page)
			->render($base_url);

		//Set the title
		$vars['title_page'] = $title_page;

		//set the buttons
		$vars['action_buttons'] = $action_buttons;

		return $this->output('overview', $vars, $title_page);
	}

	/**
	 * @return array
	 */
	public function delete_all_logs()
	{
		//delete member
		if(ee()->input->post('confirm') == 'ok')
		{
			$result = ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Log')->all();
			$result->delete();

			//set a message
			ee('CP/Alert')->makeInline(REINOS_ICONFONT_MAP.'_notice')
				->asSuccess()
				->withTitle(lang('success'))
				->addToBody('Logs deleted')
				->defer();

			ee()->functions->redirect(ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/logs/'));
		}

		$vars = array();
		$vars['title_page'] = 'Delete all Logs';
		$vars['form_url'] = ee('CP/URL', 'cp/addons/settings/'.REINOS_ICONFONT_MAP.'/delete_all_logs/');

		return $this->output('delete', $vars, $vars['title_page']);
	}


	// ----------------------------------------------------------------

	/**
	 * Run a specific update file
	 */
	public function update()
	{
		if(in_array(ee()->input->get('version'), $this->updates))
		{
			ee(REINOS_ICONFONT_SERVICE_NAME.':Installer')->init_update(ee()->input->get('version'));
			die('updater '.ee()->input->get('version'). ' executed');
		}

		die('Cannot run updater '.ee()->input->get('version'));
	}

	// ----------------------------------------------------------------

	/**
	 * call any act route from the cp
	 */
	public function ajax()
	{
		include 'mod.'.REINOS_ICONFONT_MAP.'.php';
		$mod = new Reinos_iconfont();
        $mod->act_route();
    }

	// ----------------------------------------------------------------

	/**
	 * Delete Dorm
	 *
	 * @param int $form_id
	 * @return array
	 */
//	public function delete_form($id = 0)
//	{
//		//delete member
//		if(ee()->input->post('confirm') == 'ok')
//		{
//			$form = ee('Model')->get('email_form:Form')->filter('form_id', $form_id)->first();
//			$form->delete();
//
//			//set a message
//			ee('CP/Alert')->makeInline(EMAIL_QUEUE_MAP.'_notice')
//				->asSuccess()
//				->withTitle(lang('success'))
//				->addToBody('Form deleted')
//				->defer();
//
//			ee()->functions->redirect(ee('CP/URL', 'cp/addons/settings/'.EMAIL_QUEUE_MAP.'/forms/'));
//		}
//
//		$vars = array();
//		$vars['title_page'] = 'Delete form';
//      $vars['form_url'] = ee('CP/URL', 'cp/addons/settings/'.EMAIL_QUEUE_MAP.'/delete_form/'.$id);
//
//		return $this->output('delete', $vars, $vars['title_page']);
//	}

	// ----------------------------------------------------------------

	private function output($template, $vars, $heading = '')
	{
		//support for sidebar?
		$sidebar = ee('CP/Sidebar')->make();

        $sidebar->addHeader(lang(REINOS_ICONFONT_MAP.'_settings'), ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/settings'));
        $sidebar->addHeader(lang(REINOS_ICONFONT_MAP.'_log'), ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/logs'));
        $presetItem = $sidebar->addHeader(lang(REINOS_ICONFONT_MAP.'_presets'), ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/presets'))
            ->withButton(lang('new'), ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/preset_save'));

        if(ee()->uri->segment(5) == 'presets' || ee()->uri->segment(5) == 'preset_save') {
           $presetItem->isactive();
        }
/*
        if(REINOS_ICONFONT_LICENSE_ENABLED)
        {
            $sidebar->addHeader(lang(REINOS_ICONFONT_MAP.'_license'), ee('CP/URL', 'addons/settings/'.REINOS_ICONFONT_MAP.'/license'));
        }
*/
		return array(
			'body'       => ee('View')->make(REINOS_ICONFONT_SERVICE_NAME.':'.$template)->render($vars),
			'heading'    => REINOS_ICONFONT_TITLE.' - '.lang($heading)
		);
	}

	// ----------------------------------------------------------------


}
