<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

/**
 * Include the config file
 */
require_once PATH_THIRD.'reinos_iconfont/config.php';

class Reinos_iconfont_upd {

	public $version = REINOS_ICONFONT_VERSION;

	/**
	 * Constructor
	 */
	public function __construct()
	{
		//require the settings
		require PATH_THIRD.REINOS_ICONFONT_MAP.'/settings.php';
	}

	// ----------------------------------------------------------------

	/**
	 * Installation Method
	 *
	 * @return 	boolean 	TRUE
	 */
	public function install()
	{
		if (strnatcmp(phpversion(),REINOS_ICONFONT_PHP_MIN_VERSION) <= 0)
		{
			show_error(REINOS_ICONFONT_TITLE.' require PHP '.REINOS_ICONFONT_PHP_MIN_VERSION.' or higher.', 500, 'Oeps!');
			return FALSE;
		}

		//set the module data
		$mod_data = array(
			'module_name'			=> REINOS_ICONFONT_CLASS,
			'module_version'		=> REINOS_ICONFONT_VERSION,
			'has_cp_backend'		=> "y",
			'has_publish_fields'	=> 'n'
		);

		//insert the module
		ee()->db->insert('modules', $mod_data);

		//install module specific
		ee(REINOS_ICONFONT_SERVICE_NAME.':Installer')->install();

		//insert the settings data
		ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->first_import_settings();

		return TRUE;
	}

	// ----------------------------------------------------------------

	/**
	 * Uninstall
	 *
	 * @return 	boolean 	TRUE
	 */
	public function uninstall()
	{
		//delete the module
		ee()->db->where('module_name', REINOS_ICONFONT_CLASS);
		ee()->db->delete('modules');

		//uninstall module specific
		ee(REINOS_ICONFONT_SERVICE_NAME.':Installer')->uninstall();

		//remove actions
		ee()->db->where('class', REINOS_ICONFONT_CLASS);
		ee()->db->delete('actions');

		//remove the extension
		ee()->db->where('class', REINOS_ICONFONT_CLASS.'_ext');
		ee()->db->delete('extensions');

		//delete tabs
		ee()->load->library('layout');
		ee()->layout->delete_layout_tabs(ee(REINOS_ICONFONT_SERVICE_NAME.':Installer')->tabs(), REINOS_ICONFONT_MAP);

		return TRUE;
	}

	// ----------------------------------------------------------------

	/**
	 * Module Updater
	 *
	 * @param string $current
	 * @return bool TRUE
	 */
	public function update($current = '')
	{
		if ($current == '' OR $current == $this->version)
			return FALSE;

		ee(REINOS_ICONFONT_SERVICE_NAME.':Installer')->update($current);

		return true;
	}
}
