<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
 ========================================================
 Plugin Search Marker
 --------------------------------------------------------
 Copyright: Oliver Heine
 License:   Freeware
 http://utilitees.de/ee.php/search-marker
 --------------------------------------------------------
 This addon may be used free of charge. Should you
 employ it in a commercial project of a customer or your
 own I'd appreciate a small donation.
 ========================================================
 File: pi.search_marker.php
 --------------------------------------------------------
 Purpose: Highlights search terms on an EE search results 
          page.
 ========================================================
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF
 ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT 
 LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO 
 EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE 
 OR OTHER DEALINGS IN THE SOFTWARE.
 ========================================================
   
*/


$plugin_info = array(	'pi_name'           => 'Search Marker',
			'pi_version'        => '2.0',
			'pi_author'         => 'Oliver Heine',
			'pi_author_url'     => 'https://utilitees.de/ee.php/search-marker',
			'pi_description'    => 'Highlights search terms on an EE search results page',
			'pi_usage'          => search_marker::usage()
                    );

class Search_marker
{
	var $return_data = '';
	var $search_id = '';
	var $search_term = '';
	var $search_terms = array();

// -- Constructor -- //
    public function __construct()
        {
            $this->EE = get_instance();

            $str = $this->EE->TMPL->tagdata;

            if ( ! isset($this->EE->session->cache['search_marker']['terms']))
            {
                if (strlen($this->EE->uri->query_string) < 32)
		{
                    $this->return_data = $str;
                    return '';
		}
                $search_id = substr($this->EE->uri->query_string, 0, 32);
                $query = $this->EE->db->query("SELECT keywords FROM exp_search WHERE search_id = '".$this->EE->db->escape_str($search_id)."'");

                if ($query->num_rows() > 0)
                {
                    $this->search_term = $query->row('keywords');
                }
                else
                {
                    $this->return_data = $str;
                    return;
                }

                $this->search_terms = explode(" ", $this->search_term);
                $this->EE->session->cache['search_marker']['terms'] = $this->search_terms;
            }
            else
            {
                $this->search_terms = $this->EE->session->cache['search_marker']['terms'];
            }
           
            $str = $this->highlight($str,$this->search_terms);
            $this->return_data = $str;
	}
	// END


        function highlight ($text, $words)
        {
            foreach ($words as $word)
            {
                $w = preg_quote($word);
                $regexp = "/($w)(?![^<]+>)/iu"; // Wörter innerhalb eines Tags werden ignoriert -> i Gross-/Kleinschreibung nicht beachten -> u UTF8 damit ä=Ä ü=Ü...
                $replacement = '<span class="marker">\\1</span>';
                $text = preg_replace ($regexp,$replacement ,$text);
            }
            return $text;
        }

	
	// ----------------------------------------
	//  Plugin Usage
	// ----------------------------------------

	// This function describes how the plugin is used.
	//  Make sure and use output buffering

	public static function usage()
	{
	ob_start(); 
	?>

When using the EE search module, this plugin will highlight 
the search terms on the results-page by surrounding them 
with <span class="marker"></span>.

This plugin is only intended to be used on a search results page,
that is, inside {exp:search:search_results}{/exp:search:search_results}

STEP ONE:
Add this style to your CSS and modify the color as you see fit.
.marker { background-color: #ff0; }

STEP TWO:
Wrap your fields with the plugin tags.

     {exp:search_marker}
     <p>{summary}</p>

     <p>{body}</p>
     {/exp:search_marker}


	<?php
	$buffer = ob_get_contents();
	
	ob_end_clean(); 

	return $buffer;
	}
	// END

}
// END Class
//* EOF pi.search_marker.php *//