<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Single Mailing List Module Install/Update File
 *
 * @package		ExpressionEngine 
 * @subpackage	Addons
 * @category	Module
 * @author		W3Care DevTeam
 * @link		hppts://www.w3care.com
 * @edit date	12/28/2020
 */
 
class Single_mailinglist_mailchimp_upd {
	
	public $version = '1.0';

	private $EE;

	/**
	* Constructor
	*/
	public function __construct()
	{
		$this->EE = get_instance();
	}

	/**
	* Installation Method
	*
	* @return 	boolean 	TRUE
	*/
	public function install()
	{
		$mod_data = array(
			'module_name'			=> 'Single_mailinglist_mailchimp',
			'module_version'		=> $this->version,
			'has_cp_backend'		=> 'y',
			'has_publish_fields'	=> 'n'
		);

		ee()->db->insert('modules', $mod_data);
		$data = array(
        'class'     => 'Single_mailinglist_mailchimp' ,
        'method'    => 'send_to_list'
        );
        ee()->db->insert('actions', $data);
		
		$data = array(
        'class'     => 'Single_mailinglist_mailchimp' ,
        'method'    => 'activation_action'
        );
        ee()->db->insert('actions', $data);
				
		$this->EE->load->dbforge();

		$fields = array(
    'id'   => array('type' => 'int', 'constraint' => '10', 'unsigned' => TRUE, 'auto_increment' => TRUE),
    'email_id'    => array('type' => 'varchar', 'constraint'  => '255'),
    'date' => array('type' => 'date'),
	'ip_address'    => array('type' => 'varchar', 'constraint'  => '255'),
	'status'    => array('type' => 'varchar', 'constraint'  => '255'),
	'auth_code'    => array('type' => 'varchar', 'constraint'  => '255'),
	
    ); 
		$this->EE->dbforge->add_field($fields);
		$this->EE->dbforge->add_key('id', TRUE);
		$this->EE->dbforge->create_table('mailing_list');
	
	 	$data1 = array(
        'class'     => 'Single_mailinglist_mailchimp',
        'method'    => 'fetch_template'
     );

    ee()->db->insert('actions', $data1);

		$this->EE->load->dbforge();

			$fields = array(

			'ID'   => array('type' => 'int', 'constraint' => '11', 'unsigned' => TRUE, 'auto_increment' => TRUE),

			'mailchimp_api' => array('type' => 'varchar', 'constraint' => '255'),
			
			'list_id_1' => array('type' => 'varchar', 'constraint' => '255'),
			
			'template_id' => array('type' => 'varchar', 'constraint' => '255'),
			
			'mc_template_class' => array('type' => 'varchar', 'constraint' => '255'),
			
			'selected_template_group' => array('type' => 'int', 'constraint' => '11'),
			
			'selected_template' => array('type' => 'int', 'constraint' => '11'),
			
			);

			$this->EE->dbforge->add_field($fields);

			$this->EE->dbforge->add_key('ID', TRUE);

			$this->EE->dbforge->create_table('mailchimp_mailing_settings');

			unset($fields);

		/*End of creating database and fields */

		return TRUE;
	}

	/**
	* Uninstall
	*
	* @return 	boolean 	TRUE
	*/
	public function uninstall()
	{
		$mod_id = $this->EE->db->select('module_id')->get_where('modules', array('module_name'	=> 'single_mailinglist_mailchimp'))->row('module_id');
		$this->EE->db->where('module_id', $mod_id)->delete('module_member_groups');
		$this->EE->db->where('module_name', 'single_mailinglist_mailchimp')->delete('modules');
		ee()->db->where('class', 'Single_mailinglist_mailchimp');
        ee()->db->delete('actions');
		$this->EE->load->dbforge();
		$this->EE->dbforge->drop_table('mailing_list');
		$this->EE->dbforge->drop_table('mailchimp_mailing_settings');
		return TRUE;
	}

	/**
	* Module Updater
	*
	* @return 	boolean 	TRUE
	*/
	public function update($current = '')
	{
		return TRUE;
	}
}
/* End of file upd.single_mailinglist_mailchimp.php */
/* Location: /system/user/addons/single_mailinglist_mailchimp/upd.single_mailinglist_mailchimp.php */