/*!
 * Assets
 *
 * @copyright Copyright (c) 2018 EEHarbor
 * @author    EEHarbor <help@eeharbor.com>
 * @version   4.2.2
 */
(function($){if(typeof window.Assets=="undefined"){window.Assets={}}Assets.caseInsensativeSort=function(a,b){a=a.toLowerCase();b=b.toLowerCase();return a<b?-1:(a>b?1:0)};Assets.parseTag=function(str,tag,val){return str.replace("{"+tag+"}",val)};Assets.initRte=function(sourceElement,params,filedir,kind){var sheet=new Assets.Sheet({filedirs:(filedir=="all"?filedir:[filedir]),kinds:(kind=="any"?kind:[kind]),onSelect:function(files){if(files[0].url){var cacheBustUrl=files[0].url+"?cachebuster:"+parseInt(Math.random()*100,10);window.document.dispatchEvent(new CustomEvent("filepicker:pick",{detail:cacheBustUrl}))}}});sheet.show()};Assets.AjaxQueueManager=Garnish.Base.extend({init:function(workers,callback){this._workers=workers;this._queue=[];this._callback=callback;this._busyWorkers=0},addItem:function(target,parameters,callback){this._queue.push({target:target,parameters:parameters,callback:callback})},processItem:function(){if(this._queue.length==0){if(this._busyWorkers==0){this._callback()}return}this._busyWorkers++;var item=this._queue.shift();var _t=this;$.post(item.target,item.parameters,function(data){if(typeof item.callback=="function"){item.callback(data)}_t._busyWorkers--;if(_t._busyWorkers==0&&_t._queue.length==0&&typeof _t._callback=="function"){_t._callback()}else{if(_t._queue.length>0&&_t._busyWorkers<_t._workers){while(_t._busyWorkers<_t._workers&&_t._queue.length>0){_t.processItem()}}}})},startQueue:function(){while(this._busyWorkers<this._workers&&this._queue.length>0){this.processItem()}}});Assets.Field=Garnish.Base.extend({init:function(fieldId,fieldName,settings){this.fieldId=fieldId;this.fieldName=fieldName;this.setSettings(settings);this.$field=$("#"+this.fieldId);var $btns=this.$field.next();this.$addBtn=$(".assets-add",$btns);this.$removeBtn=$(".assets-remove",$btns);this.$css=$('<style type="text/css" />').appendTo(document.body);this.filesView;this.fileSelect;this.filesSort;this.sheet;this.orderby;this.sort;this.orderFilesRequestId=0;this.selectFilesRequestId=0;this.$addBtn.click($.proxy(this,"_showSheet"));this.$removeBtn.click($.proxy(function(){if(this.$removeBtn.hasClass("assets-disabled")){return}var $files=this.settings.multi?this.fileSelect.getSelectedItems():this.filesView.getItems();this._removeFiles($files)},this));this._initFilesView()},_initFilesView:function(){if(this.settings.view=="thumbs"){this.filesView=new Assets.ThumbView($("> .assets-thumbview",this.$field))}else{this.filesView=new Assets.ListView($("> .assets-listview",this.$field),{orderby:this.orderby,sort:this.sort,onSortChange:$.proxy(this,"_onListViewSortChange")})}this.fileSelect=new Garnish.Select(this.$field,{selectedClass:"assets-selected",multi:true,vertical:(this.settings.view=="list"),onSelectionChange:$.proxy(this,"_onSelectionChange")});this.filesSort=new Garnish.DragSort({container:this.filesView.getContainer(),axis:(this.settings.view=="list"?Garnish.Y_AXIS:null),removeDraggee:true,filter:".assets-selected",helper:$.proxy(this.filesView,"getDragHelper"),caboose:$.proxy(this.filesView,"getDragCaboose"),insertion:$.proxy(this.filesView,"getDragInsertion"),onSortChange:$.proxy(function(){this.fileSelect.resetItemOrder();$(document).trigger("entry:preview")},this)});var $files=this.filesView.getItems();this._initFiles($files)},_initFiles:function($files){if(!$files.length){return}this.fileSelect.addItems($files);if(this.settings.multi){this.filesSort.addItems($files)}else{this.$addBtn.addClass("assets-disabled");this.$removeBtn.removeClass("assets-disabled")}$files.dblclick($.proxy(this,"_showProperties"));this._singleFileMenu=new Garnish.ContextMenu($files,[{label:Assets.lang.view_file,onClick:$.proxy(this,"_viewFile")},{label:Assets.lang.edit_file,onClick:$.proxy(this,"_showProperties")},"-",{label:Assets.lang.remove_file,onClick:$.proxy(this,"_removeFiles")}],{menuClass:"assets-contextmenu"});if(this.settings.multi){this._multiFileMenu=new Garnish.ContextMenu($files,[{label:Assets.lang.remove_files,onClick:$.proxy(this,"_removeFiles")}],{menuClass:"assets-contextmenu"});this._multiFileMenu.disable()}$(document).trigger("entry:preview")},_onSelectionChange:function(){if(this.settings.multi){var totalSelected=this.fileSelect.getTotalSelected();if(totalSelected){this.$removeBtn.removeClass("assets-disabled")}else{this.$removeBtn.addClass("assets-disabled")}if(totalSelected==1){this._singleFileMenu.enable();if(this.settings.multi){this._multiFileMenu.disable()}}else{if(typeof(this._singleFileMenu)!="undefined"){this._singleFileMenu.disable()}if(this.settings.multi&&typeof(this._multiFileMenu)!="undefined"){this._multiFileMenu.enable()}}}},_onListViewSortChange:function(orderby,sort){this.orderby=orderby;this.sort=sort;this.orderFilesRequestId++;data={ACT:Assets.actions.get_ordered_files_view,requestId:this.orderFilesRequestId,view:this.settings.view,field_id:this.fieldId,field_name:this.fieldName,orderby:this.orderby,sort:this.sort};for(var i=0;i<this.settings.show_cols.length;i++){data["show_cols["+i+"]"]=this.settings.show_cols[i]}this.filesView.getItems().each(function(i){data["files["+i+"]"]=$(this).attr("data-id")});this.fileSelect.destroy();this.filesView.destroy();$.post(Assets.siteUrl,data,$.proxy(function(data,textStatus){if(textStatus=="success"){if(data.requestId!=this.orderFilesRequestId){return}this.$field.html(data.html);this._initFilesView()}},this),"json")},_showSheet:function(){if(!this.sheet){this.sheet=new Assets.Sheet({multiSelect:this.settings.multi,filedirs:this.settings.filedirs,onSelect:$.proxy(this,"_selectFiles"),namespace:this.settings.namespace})}var selectedFiles=[],$selectedFiles=this.filesView.getItems();for(var i=0;i<$selectedFiles.length;i++){var fileId=$selectedFiles[i].getAttribute("data-id");selectedFiles.push(fileId)}this.sheet.show({disabledFiles:selectedFiles})},_viewFile:function(event){var fileId=event.currentTarget.getAttribute("data-id"),url=Assets.siteUrl+"?ACT="+Assets.actions.view_file+"&file_id="+fileId;window.open(url)},_showProperties:function(event){this.propertiesHud=new Assets.Properties($(event.currentTarget))},_removeFiles:function($files){if($files.currentTarget){$files=this.fileSelect.getSelectedItems()}this.fileSelect.removeItems($files);this.filesSort.removeItems($files);this.filesView.removeItems($files);if(!this.settings.multi){this.$addBtn.removeClass("assets-disabled");this.$removeBtn.addClass("assets-disabled")}$(document).trigger("entry:preview")},_selectFiles:function(files){this.selectFilesRequestId++;var data={ACT:Assets.actions.get_selected_files,requestId:this.selectFilesRequestId,view:this.settings.view,thumb_size:this.settings.thumb_size,show_filenames:this.settings.show_filenames,prev_total:this.filesView.totalFiles,field_id:this.fieldId,field_name:this.fieldName};if(this.settings.view=="list"){for(var i=0;i<this.settings.show_cols.length;i++){data["show_cols["+i+"]"]=this.settings.show_cols[i]}}for(var i=0;i<files.length;i++){data["file_id["+i+"]"]=files[i].id}$.post(Assets.siteUrl,data,$.proxy(function(postData,textStatus){if(textStatus=="success"){if(postData.requestId!=this.selectFilesRequestId){return}var $files=$(postData.html);if(this.settings.view=="list"){$files=$files.filter("tr")}else{$files=$files.filter("li")}this.filesView.addItems($files);this._initFiles($files);console.log("selectFiles",this.$field,$("#"+this.fieldId),data,data.field_id,data.field_name);$('input[name="'+data.field_id+'[]"]').trigger("change");$("<style>"+postData.css+"</style>").appendTo("head")}},this),"json")}});Assets.FileManager=Garnish.Base.extend({init:function($fm,settings){this.$fm=$fm;this.setSettings(settings,Assets.FileManager.defaults);if(this.settings.mode=="full"){this.$pageContents=$(".pageContents")}this.$main=$(".assets-fm-main",this.$fm);this.$toolbar=$("> .assets-fm-toolbar",this.$main);if(this.settings.mode=="full"){this.$scrollpane=Garnish.$win}else{this.$scrollpane=this.$main}this.viewBtns=[];var $viewBtnContainer=$(".assets-fm-view:first",this.$toolbar),$viewBtns=$("li",$viewBtnContainer);for(var i=0;i<$viewBtns.length;i++){var $btn=$($viewBtns[i]),view=$btn.attr("data-view");this.viewBtns[view]=$btn}this.viewSelect=new Garnish.Select($viewBtnContainer,{selectedClass:"assets-active",multi:false,waitForDblClick:false,horizontal:true,arrowsChangeSelection:false,onSelectionChange:$.proxy(this,"switchView")});this.viewSelect.addItems($viewBtns);this.$refresh=$(".assets-fm-refresh",this.$toolbar);this.$sidebar=$("> .assets-fm-sidebar",this.$fm);this.$upload=$("> .assets-fm-upload",this.$sidebar);if(this.$upload.length===0){this.$upload=$(".assets-fm-upload")}this.$folders=$("> .assets-fm-folders",this.$sidebar);this.$files=$("> .assets-fm-files",this.$main);this.$uploadProgress=$("> .assets-fm-uploadprogress",this.$fm);this.$uploadProgressBar=$(".assets-fm-pb-bar",this.$uploadProgress);this.css=[];this.folders={};this.selectedFolderIds=[];this.selectedFileIds=[];this.searchTimeout=null;this.searchVal="";this.showingSearchOptions=false;this.filesRequestId=0;this.propsRequestId=0;this.fileSelect=null;this.filesView=null;this.responseArray=[];this.promptArray=[];this.currentIndexItem=0;this.lastPageReached=true;this.nextOffset=0;this._singleFileMenu=[];this._multiFileMenu=[];this.currentSource=0;this.defaultSourceState={view:"thumbs",searchMode:"shallow",orderby:"name",sort:"asc"};this.instanceState={folders:{},selectedFolders:[]};this.sourceState={};this.instanceStateStorageKey="PT_Assets_"+this.settings.namespace;if(typeof Storage!=="undefined"&&typeof localStorage[this.instanceStateStorageKey]!="undefined"){var storedState=$.evalJSON(localStorage[this.instanceStateStorageKey]);$.extend(this.instanceState,storedState)}this.sourceStateStorageKey="PT_Assets_Source_State_"+this.settings.context;if(typeof Storage!=="undefined"&&typeof localStorage[this.sourceStateStorageKey]!="undefined"){var storedSoureState=$.evalJSON(localStorage[this.sourceStateStorageKey]);$.extend(this.sourceState,storedSoureState)}this.uploader=new Assets.qq.FileUploader({element:this.$upload[0],action:Assets.siteUrl,template:'<div class="assets-qq-uploader"><div class="assets-qq-upload-drop-area"></div><div class="assets-qq-upload-button assets-btn assets-submit assets-disabled">'+Assets.lang.upload_files+'</div><ul class="assets-qq-upload-list"></ul></div>',fileTemplate:'<li><span class="assets-qq-upload-file"></span><span class="assets-qq-upload-spinner"></span><span class="assets-qq-upload-size"></span><a class="assets-qq-upload-cancel" href="#">Cancel</a><span class="assets-qq-upload-failed-text">Failed</span></li>',classes:{button:"assets-qq-upload-button",drop:"assets-qq-upload-drop-area",dropActive:"assets-qq-upload-drop-area-active",list:"assets-qq-upload-list",file:"assets-qq-upload-file",spinner:"assets-qq-upload-spinner",size:"assets-qq-upload-size",cancel:"assets-qq-upload-cancel",success:"assets-qq-upload-success",fail:"assets-qq-upload-fail"},onSubmit:$.proxy(this,"_onUploadSubmit"),onProgress:$.proxy(this,"_onUploadProgress"),onComplete:$.proxy(this,"_onUploadComplete")});this.folderSelect=new Garnish.Select(this.$folders,{selectedClass:"assets-selected",multi:false,waitForDblClick:false,vertical:true,onSelectionChange:$.proxy(this,"_updateSelectedFolders")});this.$topFolderUl=this.$folders.children().filter("ul");this.$topFolderLis=this.$topFolderUl.children().filter("li");if(!this.$topFolderLis.length){this.disableUploadBtn();return}for(var i=0;i<this.$topFolderLis.length;i++){var folder=new Assets.FileManagerFolder(this,this.$topFolderLis[i],1)}this.setFoldersWidth();this.addListener(this.$refresh,"activate","refreshFiles");if(this.settings.mode=="full"){this.expandDropTargetFolderTimeout=null;this.folderDrag=new Garnish.DragDrop({activeDropTargetClass:"assets-selected assets-fm-dragtarget",helperOpacity:0.5,filter:$.proxy(function(){var $selected=this.folderSelect.getSelectedItems(),draggees=[];for(var i=0;i<$selected.length;i++){var li=$($selected[i]).parent()[0];if($.inArray(li,this.$topFolderLis)!=-1){this.folderSelect.deselectItem($($selected[i]));continue}draggees.push(li)}return $(draggees)},this),helper:$.proxy(function($folder){var $helper=$('<ul class="assets-fm-folderdrag" />').append($folder);$("> a",$folder).removeClass("assets-fm-expanded");$("> ul",$folder).hide();$helper.width(this.$folders[0].scrollWidth);return $helper},this),dropTargets:$.proxy(function(){var targets=[];for(var folderId in this.folders){var folder=this.folders[folderId];if(folder.visible&&$.inArray(folder.$li[0],this.folderDrag.$draggee)==-1){targets.push(folder.$a)}}return targets},this),onDragStart:$.proxy(function(){this.tempExpandedFolders=[];$("> a.assets-fm-expanded + ul",this.folderDrag.$draggee).hide()},this),onDropTargetChange:$.proxy(this,"_onDropTargetChange"),onDragStop:$.proxy(function(){$("> a.assets-fm-expanded + ul",this.folderDrag.$draggee).show();if(this.folderDrag.$activeDropTarget&&this.folderDrag.$activeDropTarget.siblings("ul").find(">li").filter(this.folderDrag.$draggee).length==0){var targetFolderId=this.folderDrag.$activeDropTarget.attr("data-id");this._collapseExtraExpandedFolders(targetFolderId);var folderIds=[],folderNames=[];for(var i=0;i<this.folderDrag.$draggee.length;i++){var $a=$("> a",this.folderDrag.$draggee[i]),folderId=$a.attr("data-id"),folder=this.folders[folderId];folderNames[folderId]=$a.text();if(folder.parent.id!=targetFolderId){folderIds.push(folderId)}}if(folderIds.length){folderIds.sort();folderIds.reverse();this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");var parameterArray=[];for(var i=0;i<folderIds.length;i++){parameterArray.push({ACT:Assets.actions.move_folder,old_id:folderIds[i],parent_id:targetFolderId,folder_name:folderNames[i]})}this.responseArray=[];this.filesRequestId++;var fileMoveList=[];var folderDeleteList=[];var changedFolderIds={};var removeFromTree=[];var onMoveFinish=$.proxy(function(responseArray){this.promptArray=[];for(var i=0;i<responseArray.length;i++){var data=$.evalJSON(responseArray[i]);if(data.success){if(data.transfer_list&&data.delete_list&&data.changed_folder_ids){for(var ii=0;ii<data.transfer_list.length;ii++){fileMoveList.push(data.transfer_list[ii])}for(var ii=0;ii<data.delete_list.length;ii++){folderDeleteList.push(data.delete_list[ii])}for(var old_folder_id in data.changed_folder_ids){changedFolderIds[old_folder_id]=data.changed_folder_ids[old_folder_id]}removeFromTree.push(data.remove_from_tree)}}if(data.prompt){this.promptArray.push(data)}if(data.error){alert(data.error)}}if(this.promptArray.length>0){var promptCallback=$.proxy(function(returnData){this.$files.html("");var newParameterArray=[];for(var i=0;i<returnData.length;i++){if(returnData[i].choice=="cancel"){continue}var lookingFor=returnData[i].file;for(var ii=0;ii<parameterArray.length;ii++){if(parameterArray[ii].old_id==lookingFor){parameterArray[ii].action=returnData[i].choice;newParameterArray.push(parameterArray[ii])}}}if(newParameterArray.length==0){$.proxy(this,"_performActualFolderMove",fileMoveList,folderDeleteList,changedFolderIds,removeFromTree)()}else{this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");moveFolder(newParameterArray,0,onMoveFinish)}},this);this._showBatchPrompts(this.promptArray,promptCallback);this.$fm.removeClass("assets-loading");this.$uploadProgress.hide()}else{$.proxy(this,"_performActualFolderMove",fileMoveList,folderDeleteList,changedFolderIds,removeFromTree)()}},this);var moveFolder=$.proxy(function(parameterArray,parameterIndex,callback){if(parameterIndex==0){this.responseArray=[]}$.post(Assets.siteUrl,parameterArray[parameterIndex],$.proxy(function(data){this.responseArray.push(data);var width=Math.min(100,Math.round(100*++parameterIndex/parameterArray.length))+"%";this.$uploadProgressBar.width(width);if(parameterIndex>=parameterArray.length){callback(this.responseArray)}else{moveFolder(parameterArray,parameterIndex,callback)}},this))},this);moveFolder(parameterArray,0,onMoveFinish);return}}else{this._collapseExtraExpandedFolders()}this.folderDrag.returnHelpersToDraggees()},this)});this.fileDrag=new Garnish.DragDrop({activeDropTargetClass:"assets-selected assets-fm-dragtarget",helperOpacity:0.5,filter:$.proxy(function(){return this.fileSelect.getSelectedItems()},this),helper:$.proxy(function($file){return this.filesView.getDragHelper($file)},this),dropTargets:$.proxy(function(){var targets=[];for(var folderId in this.folders){var folder=this.folders[folderId];if(folder.visible){targets.push(folder.$a)}}return targets},this),onDragStart:$.proxy(function(){this.tempExpandedFolders=[];$selectedFolders=this.folderSelect.getSelectedItems();$selectedFolders.removeClass("assets-selected")},this),onDropTargetChange:$.proxy(this,"_onDropTargetChange"),onDragStop:$.proxy(function(){if(this.fileDrag.$activeDropTarget){this.fileDrag.$activeDropTarget.addClass("assets-selected");var targetFolderId=this.fileDrag.$activeDropTarget.attr("data-id");var originalFileIds=[],newFileNames=[];for(var i=0;i<this.fileDrag.$draggee.length;i++){var originalFileId=this.fileDrag.$draggee[i].getAttribute("data-id"),fileName=this.fileDrag.$draggee[i].getAttribute("data-file_name");originalFileIds.push(originalFileId);newFileNames.push(fileName)}if(originalFileIds.length){this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");var parameterArray=[];for(var i=0;i<originalFileIds.length;i++){parameterArray.push({ACT:Assets.actions.move_file,old_id:originalFileIds[i],folder_id:targetFolderId,file_name:newFileNames[i]})}var onMoveFinish=$.proxy(function(responseArray){this.promptArray=[];for(var i=0;i<responseArray.length;i++){var data=$.evalJSON(responseArray[i]);if(data.success){if(data.old_file_id&&data.file_id){this._updateFileId(data.old_file_id,data.file_id)}}if(data.prompt){this.promptArray.push(data)}if(data.error){alert(data.error)}}this.$fm.removeClass("assets-loading");this.$uploadProgress.hide();if(this.promptArray.length>0){var promptCallback=$.proxy(function(returnData){this.$files.html("");var newParameterArray=[];for(var i=0;i<returnData.length;i++){if(returnData[i].choice=="cancel"){continue}for(var ii=0;ii<parameterArray.length;ii++){if(parameterArray[ii].file_name==returnData[i].file){parameterArray[ii].action=returnData[i].choice;newParameterArray.push(parameterArray[ii])}}}if(newParameterArray.length==0){this._updateSelectedFolders()}else{this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");this._moveFile(newParameterArray,0,onMoveFinish)}},this);this.fileDrag.fadeOutHelpers();this._showBatchPrompts(this.promptArray,promptCallback)}else{this.fileDrag.fadeOutHelpers();this._updateSelectedFolders()}},this);this._moveFile(parameterArray,0,onMoveFinish);return}}else{this._collapseExtraExpandedFolders()}$selectedFolders.addClass("assets-selected");this.fileDrag.returnHelpersToDraggees()},this)})}this._moveFile=$.proxy(function(parameterArray,parameterIndex,callback){if(parameterIndex==0){this.responseArray=[]}$.post(Assets.siteUrl,parameterArray[parameterIndex],$.proxy(function(data){this.responseArray.push(data);var width=Math.min(100,Math.round(100*++parameterIndex/parameterArray.length))+"%";this.$uploadProgressBar.width(width);if(parameterIndex>=parameterArray.length){callback(this.responseArray)}else{this._moveFile(parameterArray,parameterIndex,callback)}},this))},this);this._performActualFolderMove=$.proxy(function(fileMoveList,folderDeleteList,changedFolderIds,removeFromTree){this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");var moveCallback=$.proxy(function(folderDeleteList,changedFolderIds,removeFromTree){var folder;for(var old_folder_id in changedFolderIds){var new_value=changedFolderIds[old_folder_id].new_id;var new_parent=changedFolderIds[old_folder_id].new_parent_id;var old_folder=this.folders[old_folder_id];this.folders[new_value]=old_folder;$('li.assets-fm-folder > a[data-id="'+old_folder_id+'"]:first').attr("data-id",new_value);folder=this.folders[new_value];folder.moveTo(new_parent)}for(var i=0;i<folderDeleteList.length;i++){var postData={ACT:Assets.actions.delete_folder,folder_id:folderDeleteList[i]};$.post(Assets.siteUrl,postData)}if(removeFromTree.length>0){for(var i=0;i<removeFromTree.length;i++){if(removeFromTree[i].length){this.folders[removeFromTree[i]].onDelete(true)}}}this.$fm.removeClass("assets-loading");this.$uploadProgress.hide();this._updateSelectedFolders();this.folderDrag.returnHelpersToDraggees()},this);for(var i=0;i<fileMoveList.length;i++){fileMoveList[i].ACT=Assets.actions.move_file}if(fileMoveList.length>0){this._moveFile(fileMoveList,0,$.proxy(function(){moveCallback(folderDeleteList,changedFolderIds,removeFromTree)},this))}else{moveCallback(folderDeleteList,changedFolderIds,removeFromTree)}},this);this.$searchInput=$(".assets-fm-search:first input",this.$toolbar);this.$searchOptions=$(".assets-fm-searchoptions:first",this.$toolbar);this.$searchModeCheckbox=$("input",this.$searchOptions);if(this.getSourceState("searchMode")=="deep"){this.$searchModeCheckbox.prop("checked",true)}this.$searchInput.keydown($.proxy(this,"_onSearchKeyDown"));this.$searchModeCheckbox.change($.proxy(this,"_onSearchModeChange"));for(var folder in this.instanceState.folders){if(this.instanceState.folders[folder]=="expanded"&&typeof this.folders[folder]!=="undefined"&&this.folders[folder].hasSubfolders()){this.folders[folder]._prepForSubfolders();this.folders[folder].expand()}}var folderSelected=false;for(var i=0;i<this.instanceState.selectedFolders.length;i++){if(typeof this.folders[this.instanceState.selectedFolders[i]]!=="undefined"){var folder=this.folders[this.instanceState.selectedFolders[i]];this.folderSelect.selectItem(folder.$a,true);this.currentSource=folder.$a.parents("[data-source_id]").data("source_id");folderSelected=true;break}}if(!folderSelected){this.folderSelect.selectItem(this.$folders.find("li:first a:first"),true)}if(this.settings.mode=="full"){this.folderOffset=this.$folders.offset().top;this.foldersFixed=false}this.viewSelect.selectItem(this.viewBtns[this.getSourceState("view")]);this._updateSelectedFolders()},_updateSelectedFolders:function(){this.selectedFolderIds=[];var $selected=this.folderSelect.getSelectedItems();for(var i=0;i<$selected.length;i++){this.selectedFolderIds.push($($selected[i]).attr("data-id"));this.currentSource=$($selected[i]).parents("[data-source_id]").data("source_id")}this.setInstanceState("selectedFolders",this.selectedFolderIds);this.eraseSearch();this.offset=0;this.updateFiles();if(this.selectedFolderIds.length==1&&!$($selected[0]).data("no_uploads")){this.enableUploadBtn()}else{this.disableUploadBtn()}this.viewBtns[this.getSourceState("view")].addClass("assets-active").siblings().removeClass("assets-active")},enableUploadBtn:function(){this.uploader._button._input.removeAttribute("disabled");this.uploader._button._input.style.cursor="pointer";Assets.qq.removeClass(this.uploader._button._element,"assets-disabled");this.uploader.setParams({folder:this.selectedFolderIds[0],ACT:Assets.actions.upload_file})},disableUploadBtn:function(){this.uploader._button._input.setAttribute("disabled","disabled");this.uploader._button._input.style.cursor="default";Assets.qq.addClass(this.uploader._button._element,"assets-disabled")},setFoldersWidth:function(){this.$topFolderUl.width("auto");var scrollWidth=this.$folders[0].scrollWidth,width=Math.max(scrollWidth,225);this.$topFolderUl.width(width);if(this.settings.mode=="full"){this.$files.css("min-height",this.$folders.outerHeight())}},_onDropTargetChange:function($dropTarget){clearTimeout(this.expandDropTargetFolderTimeout);if($dropTarget){var folderId=$dropTarget.attr("data-id");if(folderId&&typeof this.folders[folderId]!="undefined"){this.dropTargetFolder=this.folders[folderId];if(this.dropTargetFolder.hasSubfolders()&&!this.dropTargetFolder.expanded){this.expandDropTargetFolderTimeout=setTimeout($.proxy(this,"_expandDropTargetFolder"),750)}}else{this.dropTargetFolder=null}}},_expandDropTargetFolder:function(){this._collapseExtraExpandedFolders(this.dropTargetFolder.id);this.dropTargetFolder.expand();this.tempExpandedFolders.push(this.dropTargetFolder);var dragger=this.folderDrag.dragging?this.folderDrag:this.fileDrag;for(var i=0;i<this.dropTargetFolder.subfolders.length;i++){var subfolder=this.dropTargetFolder.subfolders[i];dragger.$dropTargets.push(subfolder.$a)}},_collapseExtraExpandedFolders:function(dropTargetFolderId){clearTimeout(this.expandDropTargetFolderTimeout);for(var i=this.tempExpandedFolders.length-1;i>=0;i--){var folder=this.tempExpandedFolders[i];if(!dropTargetFolderId||!folder.isParent(dropTargetFolderId)){folder.collapse();this.tempExpandedFolders.splice(i,1)}}},_onUploadSubmit:function(id,fileName){if(!this.uploader.getInProgress()){this.promptArray=[];this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");this._uploadFileProgress={};this._uploadTotalFiles=1;this._uploadedFiles=0}else{this._uploadTotalFiles++}this._uploadFileProgress[id]=0},_onUploadProgress:function(id,fileName,loaded,total){this._uploadFileProgress[id]=loaded/total;this._updateProgressBar()},_onUploadComplete:function(id,fileName,response){if(typeof response.success=="undefined"&&typeof response.prompt=="undefined"&&typeof response.error=="undefined"){alert(Assets.lang.couldnt_upload)}this._uploadFileProgress[id]=1;this._updateProgressBar();if(response.success||response.prompt){this._uploadedFiles++;if(this.settings.multiSelect||!this.selectedFileIds.length){this.selectedFileIds.push(response.file_id)}if(response.prompt){this.promptArray.push(response)}}if(!this.uploader.getInProgress()){if(this.promptArray.length>0){this._hideProgressBar();this.$fm.removeClass("assets-loading");this._showBatchPrompts(this.promptArray,this._uploadFollowup)}else{if(this._uploadedFiles){this.updateFiles($.proxy(this,"_hideProgressBar"))}else{this._hideProgressBar();this.$fm.removeClass("assets-loading")}}}},_uploadFollowup:function(returnData){this.$files.html("");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");var finalCallback=$.proxy(function(){this.$fm.removeClass("assets-loading");this.updateFiles($.proxy(this,"_hideProgressBar"))},this);var doFollowup=$.proxy(function(parameterArray,parameterIndex,callback){var postData={ACT:Assets.actions.upload_file,additional_info:parameterArray[parameterIndex].additional_info,file_name:parameterArray[parameterIndex].file,action:parameterArray[parameterIndex].choice};$.post(Assets.siteUrl,postData,$.proxy(function(data){var width=Math.min(100,Math.round(100*++parameterIndex/parameterArray.length))+"%";data=$.evalJSON(data);this.selectedFileIds.push(data.file_id);this.$uploadProgressBar.width(width);if(parameterIndex==parameterArray.length){callback()}else{doFollowup(parameterArray,parameterIndex,callback)}},this))},this);doFollowup(returnData,0,finalCallback)},_updateProgressBar:function(){var totalPercent=0;for(var id in this._uploadFileProgress){totalPercent+=this._uploadFileProgress[id]}var width=Math.round(100*totalPercent/this._uploadTotalFiles)+"%";this.$uploadProgressBar.width(width)},_hideProgressBar:function(){this.$uploadProgress.fadeOut($.proxy(function(){this.$uploadProgress.hide()},this))},_renameFile:function(event){var fileId=event.currentTarget.getAttribute("data-id"),oldName=event.currentTarget.getAttribute("data-file_name"),newName=prompt(Assets.lang.rename,oldName);if(newName&&newName!=oldName){this.$fm.addClass("assets-loading");var postData={ACT:Assets.actions.move_file,old_id:fileId,folder_id:event.currentTarget.getAttribute("data-folder"),file_name:newName};var handleRename=function(data,textStatus){if(typeof data=="string"){data=$.evalJSON(data)}this.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.prompt){this._showPrompt(data.prompt,data.choices,$.proxy(function(choice){if(choice!="cancel"){postData.action=choice;$.post(Assets.siteUrl,postData,$.proxy(handleRename,this))}},this))}if(data.success){this._updateFileId(data.old_file_id,data.file_id);this.updateFiles()}if(data.error){alert(data.error)}}};$.post(Assets.siteUrl,postData,$.proxy(handleRename,this),"json")}},_updateFileId:function(oldId,newId){var selIndex=$.inArray(oldId,this.selectedFileIds);if(selIndex!=-1){this.selectedFileIds[selIndex]=newId}},_deleteFile:function(event){var fileId=event.currentTarget.getAttribute("data-id");var fileName=event.currentTarget.getAttribute("data-file_name");if(confirm(Assets.parseTag(Assets.lang.confirm_delete_file,"file",fileName))){this.$fm.addClass("assets-loading");var postData={ACT:Assets.actions.delete_file,file_id:fileId};$.post(Assets.siteUrl,postData,$.proxy(function(data,textStatus){this.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.success){this.updateFiles()}if(data.error){alert(data.error)}}},this),"json")}},_deleteFiles:function(event){if(confirm(Assets.parseTag(Assets.lang.confirm_delete_files,"num",this.fileSelect.getTotalSelected()))){this.$fm.addClass("assets-loading");var postData={ACT:Assets.actions.delete_file};var $selected=this.fileSelect.getSelectedItems();for(var i=0;i<$selected.length;i++){postData["file_id["+i+"]"]=$selected[i].getAttribute("data-id")}$.post(Assets.siteUrl,postData,$.proxy(function(data,textStatus){this.$fm.removeClass("assets-loading");if(textStatus=="success"){var updateFiles=false;for(var i=0;i<data.length;i++){if(data[i].success){updateFiles=true}if(data[i].error){alert(data[i].error)}}if(updateFiles){this.updateFiles()}}},this),"json")}},_viewFile:function(event){var fileId=event.currentTarget.getAttribute("data-id"),url=Assets.siteUrl+"?ACT="+Assets.actions.view_file+"&file_id="+fileId;window.open(url)},_showProperties:function(event){new Assets.Properties($(event.currentTarget))},_onSearchKeyDown:function(event){if(event.metaKey||event.ctrlKey){return}event.stopPropagation();clearTimeout(this.searchTimeout);setTimeout($.proxy(function(){switch(event.keyCode){case 13:event.preventDefault();this._checkKeywordVal();break;case 27:event.preventDefault();this.$searchInput.val("");this._checkKeywordVal();break;default:this.searchTimeout=setTimeout($.proxy(this,"_checkKeywordVal"),500)}},this),0)},_checkKeywordVal:function(){if(this.searchVal!==(this.searchVal=this.$searchInput.val())){if(this.searchVal&&!this.showingSearchOptions){this._showSearchOptions()}else{if(!this.searchVal&&this.showingSearchOptions){this._hideSearchOptions()}}this.updateFiles()}},_showSearchOptions:function(){this.showingSearchOptions=true;this.$searchOptions.css({display:"block",height:"auto"});var height=this.$searchOptions.height();this.$searchOptions.height(0).animate({height:height},"fast",$.proxy(function(){this.$searchOptions.css("height","auto")},this))},_hideSearchOptions:function(){this.showingSearchOptions=false;this.$searchOptions.animate({height:0},"fast",$.proxy(function(){this.$searchOptions.hide()},this))},_onSearchModeChange:function(){if(this.$searchModeCheckbox.prop("checked")){var searchMode="deep"}else{var searchMode="shallow"}this.setSourceState("searchMode",searchMode);this.updateFiles()},eraseSearch:function(){this.$searchInput.val("");this.searchVal=""},setInstanceState:function(key,value){if(typeof key=="string"){var newState={};newState[key]=value}else{var newState=key}$.extend(this.instanceState,newState);if(typeof Storage!=="undefined"){localStorage[this.instanceStateStorageKey]=$.toJSON(this.instanceState)}},setFolderState:function(folder,state){var newStates=this.instanceState.folders;newStates[folder]=state;this.setInstanceState("folders",newStates)},setSourceState:function(key,value){if(typeof(this.sourceState[this.currentSource])=="undefined"){this.sourceState[this.currentSource]=this.defaultSourceState}if(typeof key=="string"){var newState={};newState[key]=value}else{var newState=key}$.extend(this.sourceState[this.currentSource],newState);if(typeof Storage!=="undefined"){localStorage[this.sourceStateStorageKey]=$.toJSON(this.sourceState)}},getSourceState:function(key){if(typeof this.sourceState[this.currentSource]=="undefined"){this.sourceState[this.currentSource]=this.defaultSourceState}return this.sourceState[this.currentSource][key]},switchView:function(){var $btn=this.viewSelect.getSelectedItems(),view=$btn.attr("data-view");this.setSourceState("view",view);this.updateFiles()},updateFiles:function(callback){this.nextOffset=0;this.filesRequestId++;this._singleFileMenu=[];this._multiFileMenu=[];if(this.settings.mode=="full"){this.fileDrag.removeAllItems()}this._beforeLoadFiles();var postData=this._prepareFileViewPostData();if(this.fileSelect){this.fileSelect.destroy()}if(this.filesView){this.filesView.destroy()}this.fileSelect=this.filesView=null;this.$fm.addClass("assets-loading");$.post(Assets.siteUrl,postData,$.proxy(function(data,textStatus){this.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.requestId!=this.filesRequestId){return}this.discardStyles();this.$files.html(data.html);if(this.getSourceState("view")=="list"){this.filesView=new Assets.ListView($("> .assets-listview",this.$files),{orderby:this.getSourceState("orderby"),sort:this.getSourceState("sort"),onSortChange:$.proxy(function(orderby,sort){this.setSourceState({orderby:orderby,sort:sort});this.updateFiles()},this)})}else{this.filesView=new Assets.ThumbView($("> .assets-thumbview",this.$files))}this.fileSelect=new Garnish.Select(this.$files,{selectedClass:"assets-selected",multi:this.settings.multiSelect,waitForDblClick:(this.settings.multiSelect&&this.settings.mode=="select"),vertical:(this.getSourceState("view")=="list"),onSelectionChange:$.proxy(this,"_onFileSelectionChange"),$scrollpane:this.$scrollpane});var $files=this.filesView.getItems().not(".assets-disabled");this._afterLoadFiles(data,$files);this._onFileSelectionChange();if(this.selectedFileIds.length){var $selected=this.fileSelect.getSelectedItems();Garnish.scrollContainerToElement(this.$scrollpane,$selected)}if(typeof callback=="function"){callback()}this._initializePageLoader()}},this),"json")},discardStyles:function(){$.each(this.css,$.proxy(function(index){this.css[index].remove()},this));this.css=[]},_beforeLoadFiles:function(){if(typeof this.settings.onBeforeUpdateFiles=="function"){this.settings.onBeforeUpdateFiles()}},_afterLoadFiles:function(data,$files){var newCss=$('<style type="text/css">'+data.css+"</style>");this.css.push(newCss.appendTo(document.body));if(data.total>0){this.nextOffset+=data.total;this.lastPageReached=false}else{this.lastPageReached=true}this.fileSelect.addItems($files);if(this.settings.mode=="full"){this.fileDrag.addItems($files)}this.addListener($files,"dblclick",function(ev){switch(this.settings.mode){case"select":clearTimeout(this.fileSelect.clearMouseUpTimeout());this.settings.onSelect();break;case"full":this._showProperties(ev);break}});var menuOptions=[{label:Assets.lang.view_file,onClick:$.proxy(this,"_viewFile")}];if(this.settings.mode=="full"){menuOptions.push({label:Assets.lang.edit_file,onClick:$.proxy(this,"_showProperties")});menuOptions.push({label:Assets.lang.rename,onClick:$.proxy(this,"_renameFile")});menuOptions.push("-");menuOptions.push({label:Assets.lang._delete,onClick:$.proxy(this,"_deleteFile")})}this._singleFileMenu.push(new Garnish.ContextMenu($files,menuOptions,{menuClass:"assets-contextmenu"}));if(this.settings.mode=="full"){var menu=new Garnish.ContextMenu($files,[{label:Assets.lang._delete,onClick:$.proxy(this,"_deleteFiles")}],{menuClass:"assets-contextmenu"});menu.disable();this._multiFileMenu.push(menu)}},_prepareFileViewPostData:function(){var postData={ACT:Assets.actions.get_files_view_by_folders,requestId:this.filesRequestId,view:this.getSourceState("view"),keywords:this.searchVal,search_type:this.getSourceState("searchMode")};if(this.getSourceState("view")=="list"){postData.orderby=this.getSourceState("orderby");postData.sort=this.getSourceState("sort")}if(this.selectedFolderIds.length&&this.selectedFolderIds[0]=="recent"){var i=0;for(var folderId in this.folders){postData["folders["+(i++)+"]"]=folderId}postData.special="recent"}else{for(var i in this.selectedFolderIds){postData["folders["+i+"]"]=this.selectedFolderIds[i]}}if(!this.settings.kinds||this.settings.kinds=="any"){postData.kinds="any"}else{for(var i=0;i<this.settings.kinds.length;i++){postData["kinds["+i+"]"]=this.settings.kinds[i]}}for(var i=0;i<this.settings.disabledFiles.length;i++){postData["disabled_files["+i+"]"]=this.settings.disabledFiles[i]}for(var i=0;i<this.selectedFileIds.length;i++){if(typeof this.selectedFileIds[i]!="undefined"){postData["selected_files["+i+"]"]=this.selectedFileIds[i]}}return postData},_initializePageLoader:function(){if(!this.lastPageReached){var $scrollElement=Garnish.$win;var $docElement=Garnish.$doc;if(this.settings.mode=="select"){$scrollElement=this.$main;$docElement=this.$files}var handler=function(){if(!this.$fm.hasClass("assets-page-loading")&&$scrollElement.scrollTop()+$scrollElement.height()>$docElement.height()-400){this.$fm.addClass("assets-page-loading");$scrollElement.unbind("scroll",$.proxy(handler,this));this.loadMoreFiles()}};handler.call(this);$scrollElement.bind("scroll",$.proxy(handler,this))}},loadMoreFiles:function(){this.filesRequestId++;this._beforeLoadFiles();var postData=this._prepareFileViewPostData();postData.offset=this.nextOffset;$.post(Assets.siteUrl,postData,$.proxy(function(data,textStatus){data=$.evalJSON(data);this.$fm.removeClass("assets-page-loading");if(textStatus=="success"){if(data.requestId!=this.filesRequestId){return}if(this.getSourceState("view")=="list"){$newFiles=$(data.html).find("tbody>tr")}else{$newFiles=$(data.html).find("ul li")}if($newFiles.length>0){$enabledFiles=$newFiles.not(".assets-disabled");if(this.filesView!=null){this.filesView.addItems($newFiles);this._afterLoadFiles(data,$enabledFiles)}this._initializePageLoader()}}},this))},refreshFiles:function(){var folderId=this.selectedFolderIds[0];if(folderId=="recent"){this._updateSelectedFolders();return}this.$fm.addClass("assets-loading");this.$uploadProgress.show();this.$uploadProgressBar.width("0%");var indexItems=0;this.currentIndexItem=0;var postData={ACT:Assets.actions.get_session_id};$.post(Assets.siteUrl,postData,$.proxy(function(data){data=$.evalJSON(data);var session=data.session;var queue=new Assets.AjaxQueueManager(10,$.proxy(function(){this.$uploadProgress.hide();this._updateSelectedFolders();$.post(Assets.siteUrl,{ACT:Assets.actions.finish_index,session:session,command:$.toJSON({command:"statistics"})})},this));var postData={ACT:Assets.actions.start_index,folder_id:folderId,session:session};queue.addItem(Assets.siteUrl,postData,$.proxy(function(data){data=$.evalJSON(data);if(data.error){alert(data.error);return}indexItems=data.total;for(var i=0;i<data.total;i++){var postData={ACT:Assets.actions.perform_index,session:session,folder_id:folderId,offset:i};queue.addItem(Assets.siteUrl,postData,$.proxy(function(){this.$uploadProgressBar.width(Math.min(Math.ceil(100/indexItems*(++this.currentIndexItem)),100)+"%")},this))}},this));queue.startQueue()},this))},_showPrompt:function(message,choices,callback,itemsToGo){this._promptCallback=callback;if(!this.$prompt){this.$shade=$('<div class="assets-shade" />').appendTo(document.body).hide();this.$prompt=$('<div class="assets-prompt"/>').appendTo(document.body).hide();this.$promptMessage=$('<p class="assets-prompt-msg"/>').appendTo(this.$prompt);$("<p>").html(Assets.lang.how_to_proceed).appendTo(this.$prompt);this.$promptButtons=$('<div class="assets-buttons"/>').appendTo(this.$prompt);this.$promptApplyToRemainingContainer=$('<label class="assets-applytoremaining"/>').appendTo(this.$prompt).hide();this.$promptApplyToRemainingCheckbox=$('<input type="checkbox"/>').appendTo(this.$promptApplyToRemainingContainer);this.$promptApplyToRemainingLabel=$("<span/>").appendTo(this.$promptApplyToRemainingContainer);this.addListener(this.$shade,"click","_cancelPrompt")}else{this.$promptButtons.html("");this.$promptApplyToRemainingContainer.hide();this.$promptApplyToRemainingCheckbox.prop("checked",false)}this.$promptMessage.html(message);for(var i=0;i<choices.length;i++){var $btn=$('<div class="assets-btn" data-choice="'+choices[i].value+'"/>').html(choices[i].title).appendTo(this.$promptButtons);this.addListener($btn,"activate",function(ev){var choice=ev.currentTarget.getAttribute("data-choice"),applyToRemaining=this.$promptApplyToRemainingCheckbox.prop("checked");this._selectPromptChoice(choice,applyToRemaining)})}if(itemsToGo){this.$promptApplyToRemainingContainer.show();this.$promptApplyToRemainingLabel.html(Assets.lang.apply_to_remaining_conflicts.replace("{number}",itemsToGo))}this.$prompt.show();this.$prompt.css({marginTop:-(Math.round(this.$prompt.outerHeight()/2))});this.$shade.fadeIn("fast");this.$prompt.hide().fadeIn("fast")},_selectPromptChoice:function(choice,applyToRemaining){this.$shade.fadeOut("fast");this.$prompt.fadeOut("fast",$.proxy(function(){this.$prompt.hide();this._promptCallback(choice,applyToRemaining)},this))},_cancelPrompt:function(){this._selectPromptChoice("cancel",true)},_showBatchPrompts:function(prompts,callback){this._promptBatchData=prompts;this._promptBatchCallback=callback;this._promptBatchReturnData=[];this._promptBatchNum=0;this._showNextPromptInBatch()},_showNextPromptInBatch:function(){var prompt=this._promptBatchData[this._promptBatchNum],remainingInBatch=this._promptBatchData.length-(this._promptBatchNum+1);this._showPrompt(prompt.prompt,prompt.choices,$.proxy(this,"_handleBatchPromptSelection"),remainingInBatch)},_handleBatchPromptSelection:function(choice,applyToRemaining){var prompt=this._promptBatchData[this._promptBatchNum],remainingInBatch=this._promptBatchData.length-(this._promptBatchNum+1);this._promptBatchReturnData.push({file:prompt.file_name,choice:choice,additional_info:prompt.additional_info});if(remainingInBatch){this._promptBatchNum++;if(applyToRemaining){this._handleBatchPromptSelection(choice,true)}else{this._showNextPromptInBatch()}}else{if(typeof this._promptBatchCallback=="function"){this._promptBatchCallback(this._promptBatchReturnData)}}},_onFileSelectionChange:function(){if(this.settings.mode=="full"){var i=0;if(this.fileSelect.getTotalSelected()==1){for(i=0;i<this._singleFileMenu.length;i++){this._singleFileMenu[i].enable();this._multiFileMenu[i].disable()}}else{if(this.fileSelect.getTotalSelected()>1){for(i=0;i<this._singleFileMenu.length;i++){this._singleFileMenu[i].disable();this._multiFileMenu[i].enable()}}}}this.selectedFileIds=[];var $selected=this.fileSelect.getSelectedItems();for(var i=0;i<$selected.length;i++){this.selectedFileIds.push($($selected[i]).attr("data-id"))}if(typeof this.settings.onSelectionChange=="function"){this.settings.onSelectionChange()}}},{defaults:{mode:"full",multiSelect:true,kinds:"any",disabledFiles:[],namespace:"panel",context:"sheet"}});Assets.FileManagerFolder=Garnish.Base.extend({init:function(fm,li,depth,parent){this.fm=fm;this.li=li;this.depth=depth;this.parent=parent;this.$li=$(this.li);this.$a=$("> a",this.$li);this.$toggle;this.$ul;this.id=this.$a.attr("data-id");this.visible=false;this.visibleBefore=false;this.expanded=false;this.subfolders=[];this.fm.folders[this.id]=this;this.folderName=this.$a.text().replace(/\s+$/,"").replace(/^\s+/,"");if(this.depth==1){this.onShow()}var menuOptions=[];if(!this.$a.data("no_menu")){if(this.fm.settings.mode=="full"&&this.depth>1){menuOptions.push({label:Assets.lang.rename,onClick:$.proxy(this,"_rename")});menuOptions.push("-")}menuOptions.push({label:Assets.lang.new_subfolder,onClick:$.proxy(this,"_createSubfolder")});if(this.fm.settings.mode=="full"&&this.depth>1){menuOptions.push("-");menuOptions.push({label:Assets.lang._delete,onClick:$.proxy(this,"_delete")})}new Garnish.ContextMenu(this.$a,menuOptions,{menuClass:"assets-contextmenu"})}},hasSubfolders:function(){return this.$li.find("ul li").length>0},_prepForSubfolders:function(){if(!this.$toggle){this.$toggle=$('<span class="assets-fm-toggle"></span>')}this.$toggle.prependTo(this.$a);this.addListener(this.$toggle,"mouseup,mousedown,click",function(ev){ev.stopPropagation()});this.removeListener(this.$toggle,"click");this.addListener(this.$toggle,"click","_toggle");if(!this.$ul){if(this.$li.children().filter("ul").length==0){this.$li.append("<ul></ul>")}this.$ul=this.$li.children().filter("ul")}this.$ul.appendTo(this.$li)},_unprepForSubfolders:function(){this.$toggle.remove();this.$ul.remove();this.collapse()},addSubfolder:function(subfolder){if(!this.hasSubfolders()){this._prepForSubfolders();var pos=0}else{var folders=[{name:subfolder.folderName,id:subfolder.id}];for(var i=0;i<this.subfolders.length;i++){folders.push({name:this.subfolders[i].folderName,id:this.subfolders[i].id})}folders.sort(Assets.FileManagerFolder.folderSort);for(i=0;i<folders.length;i++){if(folders[i].name==subfolder.folderName){pos=i;break}}}if(pos==0){subfolder.$li.prependTo(this.$ul);this.$ul.prepend(subfolder.$li)}else{var prevSibling=this.fm.folders[folders[pos-1].id];subfolder.$li.insertAfter(prevSibling.$li)}this.subfolders.push(subfolder)},removeSubfolder:function(subfolder){this.subfolders.splice($.inArray(subfolder,this.subfolders),1);if(!this.hasSubfolders()){this._unprepForSubfolders()}},_toggle:function(){if(this.expanded){this.collapse()}else{this.expand()}},expand:function(){if(this.expanded){return}this.expanded=true;this.$a.addClass("assets-fm-expanded");this.$ul.show();this._onShowSubfolders();this.fm.setFoldersWidth();this.fm.setFolderState(this.id,"expanded")},collapse:function(){if(!this.expanded){return}this.expanded=false;this.$a.removeClass("assets-fm-expanded");this.$ul.hide();this._onHideSubfolders();this.fm.setFoldersWidth();this.fm.setFolderState(this.id,"collapsed")},onShow:function(){this.visible=true;this.fm.folderSelect.addItems(this.$a);if(this.depth>1){if(this.fm.settings.mode=="full"){this.fm.folderDrag.addItems(this.$li)}}if(!this.visibleBefore){this.visibleBefore=true;if(this.hasSubfolders()){this._prepForSubfolders();var $lis=this.$ul.children().filter("li");for(var i=0;i<$lis.length;i++){var subfolder=new Assets.FileManagerFolder(this.fm,$lis[i],this.depth+1,this);this.subfolders.push(subfolder)}}}if(this.expanded){this._onShowSubfolders()}},onHide:function(){this.visible=false;this.fm.folderSelect.removeItems(this.$a);if(this.expanded){this._onHideSubfolders()}},_onShowSubfolders:function(){for(var i in this.subfolders){this.subfolders[i].onShow()}},_onHideSubfolders:function(){for(var i in this.subfolders){this.subfolders[i].onHide()}},onDelete:function(isTopDeletedFolder){delete this.fm.folders[this.id];var selIndex=this.fm.selectedFolderIds.indexOf(this.id);if(selIndex!=-1){this.fm.selectedFolderIds.splice(selIndex,i)}if(isTopDeletedFolder){this.parent.removeSubfolder(this);this.$li.remove()}for(var i=0;i<this.subfolders.length;i++){this.subfolders[i].onDelete()}if(!this.parent.hasSubfolders()){this.parent._unprepForSubfolders()}this.deselect();this.parent.select()},deselect:function(){this.fm.folderSelect.deselectItem(this.$a)},select:function(){this.fm.folderSelect.selectItem(this.$a)},moveTo:function(newId){var newParent=this.fm.folders[newId];if(newParent==this.parent){return}newParent.addSubfolder(this);this.parent.removeSubfolder(this);this.updateDepth(newParent.depth+1);newParent.expand();this.parent=newParent},updateId:function(id){delete this.fm.folders[this.id];var selIndex=this.fm.selectedFolderIds.indexOf(this.id);if(selIndex!=-1){this.fm.selectedFolderIds[selIndex]=path}this.id=id;this.$a.attr("data-id",this.id);this.fm.folders[this.id]=this;for(var i=0;i<this.subfolders.length;i++){var subfolder=this.subfolders[i],newId=this.id+subfolder.id+"/";subfolder.updateId(newId)}},updateName:function(name){$("span.assets-fm-label",this.$a).html(name);var folders=[{name:name,id:this.id}];for(var i=0;i<this.parent.subfolders.length;i++){if(this.parent.subfolders[i].folderName!=this.folderName){folders.push({name:this.parent.subfolders[i].folderName,id:this.parent.subfolders[i].id})}}folders.sort(Assets.FileManagerFolder.folderSort);for(i=0;i<folders.length;i++){if(folders[i].name==name){pos=i;break}}if(pos==0){this.$li.prependTo(this.parent.$ul)}else{var prevSibling=this.fm.folders[folders[pos-1].id];this.$li.insertAfter(prevSibling.$li)}this.folderName=name},updateDepth:function(depth){if(depth==this.depth){return}this.depth=depth;var padding=20+(18*this.depth);this.$a.css("padding-left",padding);for(var i=0;i<this.subfolders.length;i++){this.subfolders[i].updateDepth(this.depth+1)}},_rename:function(){var oldName=this.folderName,newName=prompt(Assets.lang.rename,oldName);if(newName&&newName!=oldName){var data={ACT:Assets.actions.rename_folder,folder_id:this.$a.attr("data-id"),new_name:newName};this.fm.$fm.addClass("assets-loading");$.post(Assets.siteUrl,data,$.proxy(function(data,textStatus){this.fm.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.success){this.updateName(data.new_name);this.fm.updateFiles()}if(data.error){alert(data.error)}}},this),"json")}},_createSubfolder:function(){var subfolderName=prompt(Assets.lang.new_subfolder);if(subfolderName){var data={ACT:Assets.actions.create_folder,parent_folder:this.id,folder_name:subfolderName};this.fm.$fm.addClass("assets-loading");$.post(Assets.siteUrl,data,$.proxy(function(data,textStatus){this.fm.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.success){subfolderName=data.folder_name;var subfolderDepth=this.depth+1,padding=20+(18*subfolderDepth),$li=$('<li class="assets-fm-folder"><a data-id="'+data.folder_id+'" style="padding-left: '+padding+'px;"><i class="fas fa-folder"></i>'+subfolderName+"</span></a></li>"),subfolder=new Assets.FileManagerFolder(this.fm,$li[0],subfolderDepth,this);this.addSubfolder(subfolder);subfolder.onShow()}if(data.error){alert(data.error)}}},this),"json")}},_delete:function(){if(confirm(Assets.parseTag(Assets.lang.confirm_delete_folder,"folder",this.folderName))){var data={ACT:Assets.actions.delete_folder,folder_id:this.$a.attr("data-id")};this.fm.$fm.addClass("assets-loading");$.post(Assets.siteUrl,data,$.proxy(function(data,textStatus){this.fm.$fm.removeClass("assets-loading");if(textStatus=="success"){if(data.success){this.onDelete(true);this.fm.updateFiles()}if(data.error){alert(data.error)}}},this),"json")}},isParent:function(folderId){var current=this;while(typeof current.parent!="undefined"&&current.parent!=null){if(current.id==folderId){return true}current=current.parent}return false}},{folderSort:function(a,b){a=a.name.toLowerCase();b=b.name.toLowerCase();return a<b?-1:(a>b?1:0)}});Assets.ListView=Garnish.Base.extend({init:function($container,settings){this.$container=$container;this.settings=(settings||{});this.$table=$("> table",this.$container);this.$ths=$("> thead > tr > th",this.$table);this.$tbody=$("> tbody",this.$table);this.$tds=$("> tbody > tr:first > td",this.$table);this.$items;this.scrollbarWidth;this.scrollLeft=0;this.orderby=this.settings.orderby;this.sort=this.settings.sort;this._findItems();if(typeof this.settings.onSortChange=="function"){this.addListener(this.$ths,"click",function(event){var orderby=$(event.currentTarget).attr("data-orderby");if(orderby!=this.orderby){this.orderby=orderby;this.sort="asc"}else{this.sort=(this.sort=="asc"?"desc":"asc")}this.settings.onSortChange(this.orderby,this.sort)})}},_findItems:function(second){this.$items=$("> tr",this.$tbody)},getItems:function(){return this.$items},addItems:function($add){this.$tbody.append($add);this._findItems()},removeItems:function($remove){$remove.remove();this._findItems()},reset:function(){this._findItems()},getContainer:function(){return this.$tbody},getDragHelper:function($file){var $container=$('<div class="assets-listview assets-lv-drag" />'),$table=$('<table cellpadding="0" cellspacing="0" border="0" />').appendTo($container),$tbody=$("<tbody />").appendTo($table);$table.width(this.$table.width());$tbody.append($file);return $container},getDragCaboose:function(){return $('<tr class="assets-lv-file assets-lv-dragcaboose" />')},getDragInsertion:function(){return $('<tr class="assts-lv-file assets-lv-draginsertion"><td colspan="'+this.$ths.length+'">&nbsp;</td></tr>')}});Assets.Properties=Garnish.Base.extend({init:function($file){this.$file=$file;this.path=$file.attr("data-id");this.saveEnabled=false;if(Assets.Properties.active){Assets.Properties.active.close()}Assets.Properties.active=this;Assets.Properties.requestId++;var data={ACT:Assets.actions.get_props,requestId:Assets.Properties.requestId,file_id:this.path};$.post(Assets.siteUrl,data,$.proxy(this,"_init"),"json")},_init:function(data,textStatus){if(textStatus!="success"||data.requestId!=Assets.Properties.requestId){return}this.hud=new Garnish.HUD(this.$file,data.html,{hudClass:"assets-hud assets-props",tipClass:"assets-tip",bodyClass:"assets-contents",triggerSpacing:5,windowSpacing:10,tipWidth:30});this.$form=$("> .assets-filedata",this.hud.$body);this.$saveBtn=$(".assets-submit",this.$form);this.$cancelBtn=$(".assets-cancel",this.$form);this.$cancelBtn.click($.proxy(this,"close"));this.$form.submit($.proxy(this,"submit"));this.$trs=$("> table > tbody > tr:not(.assets-fileinfo):not(.assets-spacer)",this.$form);this.$trs.filter(":even").addClass("assets-odd");this.$inputs=$("input,textarea,select",this.$trs);this.$trs.click($.proxy(this,"_onRowClick"));for(var i=0;i<this.$inputs.length;i++){var input=this.$inputs[i];$.data(input,"initialVal",$(input).val())}this.addListener(this.$inputs,"keydown,keypress,change","_onInputChange");var $textareas=$("textarea",this.$trs);for(var i=0;i<$textareas.length;i++){var $textarea=$($textareas[i]);new Assets.PropertiesTextField($textarea);$textarea.keydown($.proxy(this,"_onTextKeydown"))}var date=new Date(),hours=date.getHours(),minutes=date.getMinutes();if(minutes<10){minutes="0"+minutes}if(hours>=12){hours=hours-12;var meridiem=" PM"}else{var meridiem=" AM"}var time=" '"+hours+":"+minutes+meridiem+"'";var $dates=this.$inputs.filter("[data-type=date]");for(var i=0;i<$dates.length;i++){var $input=$($dates[i]);$input.datepicker({constrainInput:false,dateFormat:$.datepicker.W3C+time,defaultDate:new Date(parseInt($input.attr("data-default-date")))})}this.addListener($("#ui-datepicker-div"),"click",function(ev){ev.stopPropagation()})},_onRowClick:function(ev){if(ev.target.nodeName=="INPUT"||ev.target.nodeName=="TEXTAREA"||ev.target.nodeName=="SELECT"){return}var $firstInput=$("input,textarea,select",ev.currentTarget).first();$firstInput.focus()},_onInputChange:function(ev){setTimeout($.proxy(this,"_checkAllInputs"),0)},_checkAllInputs:function(){this.saveEnabled=false;for(var i=0;i<this.$inputs.length;i++){var input=this.$inputs[i];if(this._inputChanged(input)){this.saveEnabled=true;break}}if(this.saveEnabled){this.$saveBtn.removeClass("assets-disabled")}else{this.$saveBtn.addClass("assets-disabled")}},_inputChanged:function(input){return($(input).val()!=$.data(input,"initialVal"))},_onTextKeydown:function(ev){var $textarea=$(ev.currentTarget);if(ev.keyCode==Garnish.RETURN_KEY&&(!$textarea.attr("data-multiline")||ev.altKey)){ev.preventDefault();setTimeout($.proxy(this,"submit"),1)}},submit:function(ev){if(ev){ev.preventDefault()}if(!this.saveEnabled){return}var saveData={};for(var i=0;i<this.$inputs.length;i++){var input=this.$inputs[i];if(this._inputChanged(input)){saveData["data["+$(input).attr("name")+"]"]=$(input).val()}}if(saveData){var data=$.extend({ACT:Assets.actions.save_props,file_id:this.path},saveData);$.post(Assets.siteUrl,data);this.close()}},close:function(){this.hud.$hud.fadeOut("fast")}},{requestId:0});Assets.PropertiesTextField=Garnish.Base.extend({init:function($input){this.$input=$input;if(this.$input[0].nodeName!="TEXTAREA"){return}this.settings={maxl:(parseInt(this.$input.attr("data-maxl"))||false),multiline:(!!this.$input.attr("data-multiline")||false)};this.val=this.$input.val();this.clicked=false,this.focussed=false;this.$stage=$("<stage />").insertAfter(this.$input);this.textHeight;this.$stage.css({position:"absolute",top:-9999,left:-9999,width:this.$input.width(),lineHeight:this.$input.css("lineHeight"),fontSize:this.$input.css("fontSize"),fontFamily:this.$input.css("fontFamily"),fontWeight:this.$input.css("fontWeight"),letterSpacing:this.$input.css("letterSpacing"),wordWrap:"break-word"});this._updateInputHeight();this.$input.mousedown($.proxy(this,"_onInputMousedown"));this.$input.focus($.proxy(this,"_onInputFocus"));this.$input.blur($.proxy(this,"_onInputBlur"));this.$input.change($.proxy(this,"_checkInputVal"));if(!this.settings.multiline||this.settings.maxl){this.$input.keydown($.proxy(this,"_onInputKeydown"))}},_onInputMousedown:function(){this.clicked=true},_onInputFocus:function(){this.focussed=true;setTimeout($.proxy(this,"_fakeTextInputOnFocus"),0);this.interval=setInterval($.proxy(this,"_checkInputVal"),100)},_fakeTextInputOnFocus:function(){if(!this.clicked){this.val=this.$input.val();if(this.$input[0].setSelectionRange){var length=this.val.length*2;this.$input[0].setSelectionRange(0,length)}else{this.$input.val(this.val)}}else{this.clicked=false}},_onInputBlur:function(){this.focussed=false;clearInterval(this.interval);this._checkInputVal()},_onInputKeydown:function(ev){if(!ev.metaKey&&!ev.ctrlKey&&$.inArray(ev.keyCode,Assets.PropertiesTextField.traversingKeys)==-1&&((!this.settings.multiline&&ev.keyCode==13)||(this.settings.maxl&&this.$input.val().length>=this.settings.maxl))){ev.preventDefault()}},_checkInputVal:function(){if(this.val!==(this.val=this.$input.val())){this._updateInputHeight()}},_updateInputHeight:function(){if(!this.val){var html="&nbsp;"}else{var html=this.val.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/[\n\r]$/g,"<br/>&nbsp;").replace(/[\n\r]/g,"<br/>")}if(this.focussed){html+="m"}this.$stage.html(html);if((this.textHeight!==(this.textHeight=this.$stage.height()))&&this.textHeight){this.$input.height(this.textHeight)}}},{traversingKeys:[8,37,38,39,40]});Assets.Sheet=Garnish.Base.extend({loaded:false,init:function(settings){this.setSettings(settings,Assets.Sheet.defaults)},_load:function(){var postData={ACT:Assets.actions.build_sheet,site_id:Assets.siteId,multi:this.settings.multiSelect?"y":"n"};if(this.settings.filedirs=="all"){postData.filedirs="all"}else{for(var i=0;i<this.settings.filedirs.length;i++){postData["filedirs["+i+"]"]=this.settings.filedirs[i]}}this.$sheet.load(Assets.siteUrl,postData,$.proxy(function(responseText,textStatus,XMLHttpRequest){var $field=$(" .assets-fm",this.$sheet);this.fileManager=new Assets.FileManager($field,{mode:"select",multiSelect:this.settings.multiSelect,onSelect:$.proxy(this,"_onSelect"),kinds:this.settings.kinds,disabledFiles:this.settings.disabledFiles,namespace:this.settings.namespace,onSelectionChange:$.proxy(this,"_selectionChange")});this.loaded=true;this._updateFiles();$(" .assets-buttons .assets-cancel",this.$sheet).click($.proxy(function(){this.hide()},this));$(" .assets-buttons .assets-add",this.$sheet).click($.proxy(function(event){if($(event.target).hasClass("assets-disabled")){return}this._onSelect()},this))},this))},_selectionChange:function(){if(this.fileManager.fileSelect.getTotalSelected()>0){$(" .assets-buttons .assets-add",this.$sheet).removeClass("assets-disabled")}else{$(" .assets-buttons .assets-add",this.$sheet).addClass("assets-disabled")}},_onSelect:function(){if(!this.fileManager.fileSelect.getTotalSelected()){return}var $files=this.fileManager.fileSelect.getSelectedItems(),files=[];for(var i=0;i<$files.length;i++){var $file=$($files[i]);files.push({id:parseInt($file.attr("data-id")),url:$file.attr("data-file-url")})}this.settings.onSelect(files);this.hide()},show:function(settings){this.setSettings(settings);if(!this.$sheet||!this.$sheet.context){this.$shade=$('<div class="assets-shade" />').appendTo(document.body).hide();this.$sheet=$('<div class="assets-sheet assets-no-outline" tabindex="0" />').appendTo(document.body).hide();this.addListener(this.$shade,"click","hide");this.addListener(this.$sheet,"keydown","onKeyDown")}this.FE_form=$("#cform");this.ee_version=$("#cform").attr("data-ee-version");this.isCP=$(".assets-buttons").attr("data-view");if(this.isCP=="no-cp"||this.FE_form.length){this.$sheet.addClass("noCPSettings")}if(this.ee_version){this.$sheet.attr("data-ee-version",this.ee_version)}$(document.body).addClass("assets-noscroll");this.$shade.fadeIn("fast");this.$sheet.show().animate({top:0},"fast",$.proxy(this,"_onAfterShow"))},_onAfterShow:function(){this.$sheet.focus();if(!this.loaded){this._load()}else{this._load();this._updateFiles()}},_updateFiles:function(){var updateFiles=false;if(this.fileManager.settings.disabledFiles.length!=this.settings.disabledFiles.length){updateFiles=true}else{for(var i=0;i<this.fileManager.settings.disabledFiles.length;i++){if(this.fileManager.settings.disabledFiles[i]!=this.settings.disabledFiles[i]){updateFiles=true;break}}}if(updateFiles){this.fileManager.settings.disabledFiles=this.settings.disabledFiles;this.fileManager.updateFiles()}},hide:function(){this.$shade.fadeOut();this.$sheet.animate({top:-358},300,$.proxy(function(){this.$shade.hide();this.$sheet.hide();this.$shade.remove();this.$sheet.remove()},this));$(document.body).removeClass("assets-noscroll")},onKeyDown:function(event){switch(event.keyCode){case 27:this.hide();break;case 13:this._onSelect();break}}},{defaults:{multiSelect:false,filedirs:"all",kinds:"any",onSelect:function(){},disabledFiles:[]}});Assets.ThumbView=Garnish.Base.extend({init:function($container){this.$container=$container;this.$ul=$("> ul",this.$container);this._findItems()},_findItems:function(second){this.$items=$("> li",this.$ul)},getItems:function(){return this.$items},addItems:function($add){this.$ul.append($add);this._findItems()},removeItems:function($remove){$remove.remove();this._findItems()},reset:function(){this._findItems()},destroy:function(){delete obj},getContainer:function(){return this.$ul},getDragHelper:function($file){return $('<ul class="assets-tv-drag" />').append($file.removeClass("assets-selected"))},getDragCaboose:function(){return $('<li class="assets-tv-file assets-tv-dragcaboose" />')},getDragInsertion:function($draggee){return $draggee.first().clone().show().css({"margin-right":0,visibility:"visible"}).addClass("assets-draginsertion")}});(function(){var qq=qq||{};qq.extend=function(first,second){for(var prop in second){first[prop]=second[prop]}};qq.indexOf=function(arr,elt,from){if(arr.indexOf){return arr.indexOf(elt,from)}from=from||0;var len=arr.length;if(from<0){from+=len}for(;from<len;from++){if(from in arr&&arr[from]===elt){return from}}return -1};qq.getUniqueId=(function(){var id=0;return function(){return id++}})();qq.attach=function(element,type,fn){if(element.addEventListener){element.addEventListener(type,fn,false)}else{if(element.attachEvent){element.attachEvent("on"+type,fn)}}};qq.detach=function(element,type,fn){if(element.removeEventListener){element.removeEventListener(type,fn,false)}else{if(element.attachEvent){element.detachEvent("on"+type,fn)}}};qq.preventDefault=function(e){if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}};qq.insertBefore=function(a,b){b.parentNode.insertBefore(a,b)};qq.remove=function(element){element.parentNode.removeChild(element)};qq.contains=function(parent,descendant){if(parent==descendant){return true}if(parent.contains){return parent.contains(descendant)}else{return !!(descendant.compareDocumentPosition(parent)&8)}};qq.toElement=(function(){var div=document.createElement("div");return function(html){div.innerHTML=html;var element=div.firstChild;div.removeChild(element);return element}})();qq.css=function(element,styles){if(styles.opacity!=null){if(typeof element.style.opacity!="string"&&typeof(element.filters)!="undefined"){styles.filter="alpha(opacity="+Math.round(100*styles.opacity)+")"}}qq.extend(element.style,styles)};qq.hasClass=function(element,name){var re=new RegExp("(^| )"+name+"( |$)");return re.test(element.className)};qq.addClass=function(element,name){if(!qq.hasClass(element,name)){element.className+=" "+name}};qq.removeClass=function(element,name){var re=new RegExp("(^| )"+name+"( |$)");element.className=element.className.replace(re," ").replace(/^\s+|\s+$/g,"")};qq.setText=function(element,text){element.innerText=text;element.textContent=text};qq.children=function(element){var children=[],child=element.firstChild;while(child){if(child.nodeType==1){children.push(child)}child=child.nextSibling}return children};qq.getByClass=function(element,className){if(element.querySelectorAll){return element.querySelectorAll("."+className)}var result=[];var candidates=element.getElementsByTagName("*");var len=candidates.length;for(var i=0;i<len;i++){if(qq.hasClass(candidates[i],className)){result.push(candidates[i])}}return result};qq.obj2url=function(obj,temp,prefixDone){var uristrings=[],prefix="&",add=function(nextObj,i){var nextTemp=temp?(/\[\]$/.test(temp))?temp:temp+"["+i+"]":i;if((nextTemp!="undefined")&&(i!="undefined")){uristrings.push((typeof nextObj==="object")?qq.obj2url(nextObj,nextTemp,true):(Object.prototype.toString.call(nextObj)==="[object Function]")?encodeURIComponent(nextTemp)+"="+encodeURIComponent(nextObj()):encodeURIComponent(nextTemp)+"="+encodeURIComponent(nextObj))}};if(!prefixDone&&temp){prefix=(/\?/.test(temp))?(/\?$/.test(temp))?"":"&":"?";uristrings.push(temp);uristrings.push(qq.obj2url(obj))}else{if((Object.prototype.toString.call(obj)==="[object Array]")&&(typeof obj!="undefined")){for(var i=0,len=obj.length;i<len;++i){add(obj[i],i)}}else{if((typeof obj!="undefined")&&(obj!==null)&&(typeof obj==="object")){for(var i in obj){add(obj[i],i)}}else{uristrings.push(encodeURIComponent(temp)+"="+encodeURIComponent(obj))}}}return uristrings.join(prefix).replace(/^&/,"").replace(/%20/g,"+")};var qq=qq||{};qq.FileUploaderBasic=function(o){this._options={debug:false,action:"/server/upload",params:{},button:null,multiple:true,maxConnections:3,allowedExtensions:[],sizeLimit:0,minSizeLimit:0,onSubmit:function(id,fileName){},onProgress:function(id,fileName,loaded,total){},onComplete:function(id,fileName,responseJSON){},onCancel:function(id,fileName){},messages:{typeError:"{file} has invalid extension. Only {extensions} are allowed.",sizeError:"{file} is too large, maximum file size is {sizeLimit}.",minSizeError:"{file} is too small, minimum file size is {minSizeLimit}.",emptyError:"{file} is empty, please select files again without it.",onLeave:"The files are being uploaded, if you leave now the upload will be cancelled."},showMessage:function(message){alert(message)}};qq.extend(this._options,o);this._filesInProgress=0;this._handler=this._createUploadHandler();if(this._options.button){this._button=this._createUploadButton(this._options.button)}this._preventLeaveInProgress()};qq.FileUploaderBasic.prototype={setParams:function(params){this._options.params=params},getInProgress:function(){return this._filesInProgress},_createUploadButton:function(element){var self=this;return new qq.UploadButton({element:element,multiple:this._options.multiple&&qq.UploadHandlerXhr.isSupported(),onChange:function(input){self._onInputChange(input)}})},_createUploadHandler:function(){var self=this,handlerClass;if(qq.UploadHandlerXhr.isSupported()){handlerClass="UploadHandlerXhr"}else{handlerClass="UploadHandlerForm"}var handler=new qq[handlerClass]({debug:this._options.debug,action:this._options.action,maxConnections:this._options.maxConnections,onProgress:function(id,fileName,loaded,total){self._onProgress(id,fileName,loaded,total);self._options.onProgress(id,fileName,loaded,total)},onComplete:function(id,fileName,result){self._onComplete(id,fileName,result);self._options.onComplete(id,fileName,result)},onCancel:function(id,fileName){self._onCancel(id,fileName);self._options.onCancel(id,fileName)}});return handler},_preventLeaveInProgress:function(){var self=this;qq.attach(window,"beforeunload",function(e){if(!self._filesInProgress){return}var e=e||window.event;e.returnValue=self._options.messages.onLeave;return self._options.messages.onLeave})},_onSubmit:function(id,fileName){this._filesInProgress++},_onProgress:function(id,fileName,loaded,total){},_onComplete:function(id,fileName,result){this._filesInProgress--;if(result.error){this._options.showMessage(result.error)}},_onCancel:function(id,fileName){this._filesInProgress--},_onInputChange:function(input){if(this._handler instanceof qq.UploadHandlerXhr){this._uploadFileList(input.files)}else{if(this._validateFile(input)){this._uploadFile(input)}}this._button.reset()},_uploadFileList:function(files){for(var i=0;i<files.length;i++){if(!this._validateFile(files[i])){return}}for(var i=0;i<files.length;i++){this._uploadFile(files[i])}},_uploadFile:function(fileContainer){var id=this._handler.add(fileContainer);var fileName=this._handler.getName(id);if(this._options.onSubmit(id,fileName)!==false){this._onSubmit(id,fileName);this._handler.upload(id,this._options.params)}},_validateFile:function(file){var name,size;if(file.value){name=file.value.replace(/.*(\/|\\)/,"")}else{name=file.fileName!=null?file.fileName:file.name;size=file.fileSize!=null?file.fileSize:file.size}if(!this._isAllowedExtension(name)){this._error("typeError",name);return false}else{if(size===0){this._error("emptyError",name);return false}else{if(size&&this._options.sizeLimit&&size>this._options.sizeLimit){this._error("sizeError",name);return false}else{if(size&&size<this._options.minSizeLimit){this._error("minSizeError",name);return false}}}}return true},_error:function(code,fileName){var message=this._options.messages[code];function r(name,replacement){message=message.replace(name,replacement)}r("{file}",this._formatFileName(fileName));r("{extensions}",this._options.allowedExtensions.join(", "));r("{sizeLimit}",this._formatSize(this._options.sizeLimit));r("{minSizeLimit}",this._formatSize(this._options.minSizeLimit));this._options.showMessage(message)},_formatFileName:function(name){if(name.length>33){name=name.slice(0,19)+"..."+name.slice(-13)}return name},_isAllowedExtension:function(fileName){var ext=(-1!==fileName.indexOf("."))?fileName.replace(/.*[.]/,"").toLowerCase():"";var allowed=this._options.allowedExtensions;if(!allowed.length){return true}for(var i=0;i<allowed.length;i++){if(allowed[i].toLowerCase()==ext){return true}}return false},_formatSize:function(bytes){var i=-1;do{bytes=bytes/1024;i++}while(bytes>99);return Math.max(bytes,0.1).toFixed(1)+["kB","MB","GB","TB","PB","EB"][i]}};qq.FileUploader=function(o){qq.FileUploaderBasic.apply(this,arguments);qq.extend(this._options,{element:null,listElement:null,template:'<div class="qq-uploader"><div class="qq-upload-drop-area"><span>Drop files here to upload</span></div><div class="qq-upload-button">Upload a file</div><ul class="qq-upload-list"></ul></div>',fileTemplate:'<li><span class="qq-upload-file"></span><span class="qq-upload-spinner"></span><span class="qq-upload-size"></span><a class="qq-upload-cancel" href="#">Cancel</a><span class="qq-upload-failed-text">Failed</span></li>',classes:{button:"qq-upload-button",drop:"qq-upload-drop-area",dropActive:"qq-upload-drop-area-active",list:"qq-upload-list",file:"qq-upload-file",spinner:"qq-upload-spinner",size:"qq-upload-size",cancel:"qq-upload-cancel",success:"qq-upload-success",fail:"qq-upload-fail"}});qq.extend(this._options,o);this._element=this._options.element;this._element.innerHTML=this._options.template;this._listElement=this._options.listElement||this._find(this._element,"list");this._classes=this._options.classes;this._button=this._createUploadButton(this._find(this._element,"button"));this._bindCancelEvent();this._setupDragDrop()};qq.extend(qq.FileUploader.prototype,qq.FileUploaderBasic.prototype);qq.extend(qq.FileUploader.prototype,{_find:function(parent,type){var element=qq.getByClass(parent,this._options.classes[type])[0];if(!element){throw new Error("element not found: "+type)}return element},_setupDragDrop:function(){var self=this,dropArea=this._find(this._element,"drop");var dz=new qq.UploadDropZone({element:dropArea,onEnter:function(e){qq.addClass(dropArea,self._classes.dropActive);e.stopPropagation()},onLeave:function(e){e.stopPropagation()},onLeaveNotDescendants:function(e){qq.removeClass(dropArea,self._classes.dropActive)},onDrop:function(e){dropArea.style.display="none";qq.removeClass(dropArea,self._classes.dropActive);self._uploadFileList(e.dataTransfer.files)}});dropArea.style.display="none";qq.attach(document,"dragenter",function(e){if(!dz._isValidFileDrag(e)){return}dropArea.style.display="block"});qq.attach(document,"dragleave",function(e){if(!dz._isValidFileDrag(e)){return}var relatedTarget=document.elementFromPoint(e.clientX,e.clientY);if(!relatedTarget||relatedTarget.nodeName=="HTML"){dropArea.style.display="none"}})},_onSubmit:function(id,fileName){qq.FileUploaderBasic.prototype._onSubmit.apply(this,arguments);this._addToList(id,fileName)},_onProgress:function(id,fileName,loaded,total){qq.FileUploaderBasic.prototype._onProgress.apply(this,arguments);var item=this._getItemByFileId(id);var size=this._find(item,"size");size.style.display="inline";var text;if(loaded!=total){text=Math.round(loaded/total*100)+"% from "+this._formatSize(total)}else{text=this._formatSize(total)}qq.setText(size,text)},_onComplete:function(id,fileName,result){qq.FileUploaderBasic.prototype._onComplete.apply(this,arguments);var item=this._getItemByFileId(id);qq.remove(this._find(item,"cancel"));qq.remove(this._find(item,"spinner"));if(result.success){qq.addClass(item,this._classes.success)}else{qq.addClass(item,this._classes.fail)}},_addToList:function(id,fileName){var item=qq.toElement(this._options.fileTemplate);item.qqFileId=id;var fileElement=this._find(item,"file");qq.setText(fileElement,this._formatFileName(fileName));this._find(item,"size").style.display="none";this._listElement.appendChild(item)},_getItemByFileId:function(id){var item=this._listElement.firstChild;while(item){if(item.qqFileId==id){return item}item=item.nextSibling}},_bindCancelEvent:function(){var self=this,list=this._listElement;qq.attach(list,"click",function(e){e=e||window.event;var target=e.target||e.srcElement;if(qq.hasClass(target,self._classes.cancel)){qq.preventDefault(e);var item=target.parentNode;self._handler.cancel(item.qqFileId);qq.remove(item)}})}});qq.UploadDropZone=function(o){this._options={element:null,onEnter:function(e){},onLeave:function(e){},onLeaveNotDescendants:function(e){},onDrop:function(e){}};qq.extend(this._options,o);this._element=this._options.element;this._disableDropOutside();this._attachEvents()};qq.UploadDropZone.prototype={_disableDropOutside:function(e){if(!qq.UploadDropZone.dropOutsideDisabled){qq.attach(document,"dragover",function(e){if(e.dataTransfer){e.dataTransfer.dropEffect="none";e.preventDefault()}});qq.UploadDropZone.dropOutsideDisabled=true}},_attachEvents:function(){var self=this;qq.attach(self._element,"dragover",function(e){if(!self._isValidFileDrag(e)){return}var effect=e.dataTransfer.effectAllowed;if(effect=="move"||effect=="linkMove"){e.dataTransfer.dropEffect="move"}else{e.dataTransfer.dropEffect="copy"}e.stopPropagation();e.preventDefault()});qq.attach(self._element,"dragenter",function(e){if(!self._isValidFileDrag(e)){return}self._options.onEnter(e)});qq.attach(self._element,"dragleave",function(e){if(!self._isValidFileDrag(e)){return}self._options.onLeave(e);var relatedTarget=document.elementFromPoint(e.clientX,e.clientY);if(qq.contains(this,relatedTarget)){return}self._options.onLeaveNotDescendants(e)});qq.attach(self._element,"drop",function(e){if(!self._isValidFileDrag(e)){return}e.preventDefault();self._options.onDrop(e)})},_isValidFileDrag:function(e){var dt=e.dataTransfer,isWebkit=navigator.userAgent.indexOf("AppleWebKit")>-1;return dt&&dt.effectAllowed!="none"&&(dt.files||(!isWebkit&&dt.types.contains&&dt.types.contains("Files")))}};qq.UploadButton=function(o){this._options={element:null,multiple:false,name:"file",onChange:function(input){},hoverClass:"qq-upload-button-hover",focusClass:"qq-upload-button-focus"};qq.extend(this._options,o);this._element=this._options.element;qq.css(this._element,{position:"relative",overflow:"hidden",direction:"ltr"});this._input=this._createInput()};qq.UploadButton.prototype={getInput:function(){return this._input},reset:function(){if(this._input.parentNode){qq.remove(this._input)}qq.removeClass(this._element,this._options.focusClass);this._input=this._createInput()},_createInput:function(){var input=document.createElement("input");if(this._options.multiple){input.setAttribute("multiple","multiple")}input.setAttribute("type","file");input.setAttribute("name",this._options.name);qq.css(input,{position:"absolute",right:0,top:0,fontFamily:"Arial",fontSize:"118px",margin:0,padding:0,cursor:"pointer",opacity:0});this._element.appendChild(input);var self=this;qq.attach(input,"change",function(){self._options.onChange(input)});qq.attach(input,"mouseover",function(){qq.addClass(self._element,self._options.hoverClass)});qq.attach(input,"mouseout",function(){qq.removeClass(self._element,self._options.hoverClass)});qq.attach(input,"focus",function(){qq.addClass(self._element,self._options.focusClass)});qq.attach(input,"blur",function(){qq.removeClass(self._element,self._options.focusClass)});if(window.attachEvent){input.setAttribute("tabIndex","-1")}return input}};qq.UploadHandlerAbstract=function(o){this._options={debug:false,action:"/upload.php",maxConnections:999,onProgress:function(id,fileName,loaded,total){},onComplete:function(id,fileName,response){},onCancel:function(id,fileName){}};qq.extend(this._options,o);this._queue=[];this._params=[]};qq.UploadHandlerAbstract.prototype={log:function(str){if(this._options.debug&&window.console){console.log("[uploader] "+str)}},add:function(file){},upload:function(id,params){var len=this._queue.push(id);var copy={};qq.extend(copy,params);this._params[id]=copy;if(len<=this._options.maxConnections){this._upload(id,this._params[id])}},cancel:function(id){this._cancel(id);this._dequeue(id)},cancelAll:function(){for(var i=0;i<this._queue.length;i++){this._cancel(this._queue[i])}this._queue=[]},getName:function(id){},getSize:function(id){},getQueue:function(){return this._queue},_upload:function(id){},_cancel:function(id){},_dequeue:function(id){var i=qq.indexOf(this._queue,id);this._queue.splice(i,1);var max=this._options.maxConnections;if(this._queue.length>=max&&i<max){var nextId=this._queue[max-1];this._upload(nextId,this._params[nextId])}}};qq.UploadHandlerForm=function(o){qq.UploadHandlerAbstract.apply(this,arguments);this._inputs={}};qq.extend(qq.UploadHandlerForm.prototype,qq.UploadHandlerAbstract.prototype);qq.extend(qq.UploadHandlerForm.prototype,{add:function(fileInput){fileInput.setAttribute("name","qqfile");var id="qq-upload-handler-iframe"+qq.getUniqueId();this._inputs[id]=fileInput;if(fileInput.parentNode){qq.remove(fileInput)}return id},getName:function(id){return this._inputs[id].value.replace(/.*(\/|\\)/,"")},_cancel:function(id){this._options.onCancel(id,this.getName(id));delete this._inputs[id];var iframe=document.getElementById(id);if(iframe){iframe.setAttribute("src","javascript:false;");qq.remove(iframe)}},_upload:function(id,params){var input=this._inputs[id];if(!input){throw new Error("file with passed id was not added, or already uploaded or cancelled")}var fileName=this.getName(id);var iframe=this._createIframe(id);var form=this._createForm(iframe,params);form.appendChild(input);var self=this;this._attachLoadEvent(iframe,function(){self.log("iframe loaded");var response=self._getIframeContentJSON(iframe);self._options.onComplete(id,fileName,response);self._dequeue(id);delete self._inputs[id];setTimeout(function(){qq.remove(iframe)},1)});form.submit();qq.remove(form);return id},_attachLoadEvent:function(iframe,callback){qq.attach(iframe,"load",function(){if(!iframe.parentNode){return}if(iframe.contentDocument&&iframe.contentDocument.body&&iframe.contentDocument.body.innerHTML=="false"){return}callback()})},_getIframeContentJSON:function(iframe){var doc=iframe.contentDocument?iframe.contentDocument:iframe.contentWindow.document,response;this.log("converting iframe's innerHTML to JSON");this.log("innerHTML = "+doc.body.innerHTML);try{response=eval("("+doc.body.innerHTML+")")}catch(err){response={}}return response},_createIframe:function(id){var iframe=qq.toElement('<iframe src="javascript:false;" name="'+id+'" />');iframe.setAttribute("id",id);iframe.style.display="none";document.body.appendChild(iframe);return iframe},_createForm:function(iframe,params){var form=qq.toElement('<form method="post" enctype="multipart/form-data"></form>');var queryString=qq.obj2url(params,this._options.action);form.setAttribute("action",queryString);form.setAttribute("target",iframe.name);form.style.display="none";document.body.appendChild(form);return form}});qq.UploadHandlerXhr=function(o){qq.UploadHandlerAbstract.apply(this,arguments);this._files=[];this._xhrs=[];this._loaded=[]};qq.UploadHandlerXhr.isSupported=function(){var input=document.createElement("input");input.type="file";return("multiple" in input&&typeof File!="undefined"&&typeof(new XMLHttpRequest()).upload!="undefined")};qq.extend(qq.UploadHandlerXhr.prototype,qq.UploadHandlerAbstract.prototype);qq.extend(qq.UploadHandlerXhr.prototype,{add:function(file){if(!(file instanceof File)){throw new Error("Passed obj in not a File (in qq.UploadHandlerXhr)")}return this._files.push(file)-1},getName:function(id){var file=this._files[id];return file.fileName!=null?file.fileName:file.name},getSize:function(id){var file=this._files[id];return file.fileSize!=null?file.fileSize:file.size},getLoaded:function(id){return this._loaded[id]||0},_upload:function(id,params){var file=this._files[id],name=this.getName(id),size=this.getSize(id);this._loaded[id]=0;var xhr=this._xhrs[id]=new XMLHttpRequest();var self=this;xhr.upload.onprogress=function(e){if(e.lengthComputable){self._loaded[id]=e.loaded;self._options.onProgress(id,name,e.loaded,e.total)}};xhr.onreadystatechange=function(){if(xhr.readyState==4){self._onComplete(id,xhr)}};params=params||{};params.qqfile=name;var queryString=qq.obj2url(params,this._options.action);xhr.open("POST",queryString,true);xhr.setRequestHeader("X-Requested-With","XMLHttpRequest");xhr.setRequestHeader("X-File-Name",encodeURIComponent(name));xhr.setRequestHeader("Content-Type","application/octet-stream");xhr.send(file)},_onComplete:function(id,xhr){if(!this._files[id]){return}var name=this.getName(id);var size=this.getSize(id);this._options.onProgress(id,name,size,size);if(xhr.status==200){this.log("xhr - server response received");this.log("responseText = "+xhr.responseText);var response;try{response=eval("("+xhr.responseText+")")}catch(err){response={}}this._options.onComplete(id,name,response)}else{this._options.onComplete(id,name,{})}this._files[id]=null;this._xhrs[id]=null;this._dequeue(id)},_cancel:function(id){this._options.onCancel(id,this.getName(id));this._files[id]=null;if(this._xhrs[id]){this._xhrs[id].abort();this._xhrs[id]=null}}});Assets.qq=qq})();
/*! jQuery JSON plugin 2.4.0 | code.google.com/p/jquery-json */
(function($){var escape=/["\\\x00-\x1f\x7f-\x9f]/g,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},hasOwn=Object.prototype.hasOwnProperty;$.toJSON=typeof JSON==="object"&&$.toJSON?$.toJSON:function(o){if(o===null){return"null"}var pairs,k,name,val,type=$.type(o);if(type==="undefined"){return undefined}if(type==="number"||type==="boolean"){return String(o)}if(type==="string"){return $.quoteString(o)}if(typeof o.toJSON==="function"){return $.toJSON(o.toJSON())}if(type==="date"){var month=o.getUTCMonth()+1,day=o.getUTCDate(),year=o.getUTCFullYear(),hours=o.getUTCHours(),minutes=o.getUTCMinutes(),seconds=o.getUTCSeconds(),milli=o.getUTCMilliseconds();if(month<10){month="0"+month}if(day<10){day="0"+day}if(hours<10){hours="0"+hours}if(minutes<10){minutes="0"+minutes}if(seconds<10){seconds="0"+seconds}if(milli<100){milli="0"+milli}if(milli<10){milli="0"+milli}return'"'+year+"-"+month+"-"+day+"T"+hours+":"+minutes+":"+seconds+"."+milli+'Z"'}pairs=[];if($.isArray(o)){for(k=0;k<o.length;k++){pairs.push($.toJSON(o[k])||"null")}return"["+pairs.join(",")+"]"}if(typeof o==="object"){for(k in o){if(hasOwn.call(o,k)){type=typeof k;if(type==="number"){name='"'+k+'"'}else{if(type==="string"){name=$.quoteString(k)}else{continue}}type=typeof o[k];if(type!=="function"&&type!=="undefined"){val=$.toJSON(o[k]);pairs.push(name+":"+val)}}}return"{"+pairs.join(",")+"}"}};$.evalJSON=typeof JSON==="object"&&$.evalJSON?$.evalJSON:function(str){return eval("("+str+")")};$.secureEvalJSON=typeof JSON==="object"&&$.evalJSON?$.evalJSON:function(str){var filtered=str.replace(/\\["\\\/bfnrtu]/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,"");if(/^[\],:{}\s]*$/.test(filtered)){return eval("("+str+")")}throw new SyntaxError("Error parsing JSON, source is not valid.")};$.quoteString=function(str){if(str.match(escape)){return'"'+str.replace(escape,function(a){var c=meta[a];if(typeof c==="string"){return c}c=a.charCodeAt();return"\\u00"+Math.floor(c/16).toString(16)+(c%16).toString(16)})+'"'}return'"'+str+'"'}}(jQuery))})(jQuery);